/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.ContentFlowUtils;
import com.brikit.contentflow.model.PageRestricter;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.model.ao.RestrictedPageAO;
import com.brikit.contentflow.model.query.RestrictedPageQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class RestrictedPage
extends AbstractActiveObjectsModel {
    protected RestrictedPageAO activeObject;
    protected Workflow workflow;
    protected ApprovalStep currentApprovalStep;

    public RestrictedPage(ActiveObjects activeObjects, RestrictedPageAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    protected static RestrictedPage create(ActiveObjects activeObjects, long pageId) {
        RestrictedPageAO restrictedPageAO = (RestrictedPageAO)activeObjects.create(RestrictedPageAO.class, new DBParam[0]);
        restrictedPageAO.setPageId(pageId);
        restrictedPageAO.setSpaceKey(Confluence.getSpaceKey(pageId));
        RestrictedPage pageWorkflow = new RestrictedPage(activeObjects, restrictedPageAO);
        pageWorkflow.save();
        return pageWorkflow;
    }

    protected static RestrictedPage create(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return RestrictedPage.create(activeObjects, abstractPage.getId());
    }

    protected static RestrictedPage create(ActiveObjects activeObjects, String pageIdAsString) {
        return RestrictedPage.create(activeObjects, Confluence.getPageOrBlogPost(pageIdAsString));
    }

    protected static List<RestrictedPage> fromActiveObjects(ActiveObjects activeObjects, RestrictedPageAO[] pageWorkflowAOS) {
        ArrayList<RestrictedPage> restrictedPages = new ArrayList<RestrictedPage>(pageWorkflowAOS.length);
        for (RestrictedPageAO restrictedPageAO : pageWorkflowAOS) {
            restrictedPages.add(new RestrictedPage(activeObjects, restrictedPageAO));
        }
        return restrictedPages;
    }

    public static List<RestrictedPage> getAllRestrictedPages(ActiveObjects activeObjects, Space space) {
        RestrictedPageQuery query = new RestrictedPageQuery(activeObjects);
        return RestrictedPage.fromActiveObjects(activeObjects, query.getAllRestrictedPages(space.getKey()));
    }

    public static RestrictedPage getRestrictedPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return RestrictedPage.getRestrictedPage(activeObjects, abstractPage.getId());
    }

    public static RestrictedPage getRestrictedPage(ActiveObjects activeObjects, String pageIdString) {
        return RestrictedPage.getRestrictedPage(activeObjects, BrikitNumber.parseInteger(pageIdString));
    }

    public static RestrictedPage getRestrictedPage(ActiveObjects activeObjects, long pageId) {
        RestrictedPageAO restrictedPageAO = RestrictedPage.getRestrictedPageAO(activeObjects, pageId);
        return restrictedPageAO == null ? null : new RestrictedPage(activeObjects, restrictedPageAO);
    }

    public static RestrictedPageAO getRestrictedPageAO(ActiveObjects activeObjects, long pageId) {
        RestrictedPageQuery query = new RestrictedPageQuery(activeObjects);
        return query.getRestrictedPageForPage(pageId);
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public RestrictedPageAO getActiveObject() {
        return this.activeObject;
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    protected ContentPermissionSet getOriginalPageRestrictions() {
        ContentPermissionSet permissionSet;
        String savedRestrictionsJSON = this.getOriginalPageRestrictionsJSON();
        if (BrikitString.isSet(savedRestrictionsJSON)) {
            permissionSet = ContentFlowUtils.getOpenViewPermissions(this.getAbstractPage());
            for (ContentPermission permission : ContentFlowUtils.getContentPermissionsFromJSON(savedRestrictionsJSON)) {
                permissionSet.addContentPermission(permission);
            }
        } else {
            permissionSet = Confluence.getPageViewRestrictions(this.getAbstractPage());
            if (permissionSet == null) {
                permissionSet = ContentFlowUtils.getOpenViewPermissions(this.getAbstractPage());
            }
            savedRestrictionsJSON = ContentFlowUtils.toJSON(permissionSet);
            this.setOriginalPageRestrictionsJSON(savedRestrictionsJSON);
            this.save();
        }
        return permissionSet;
    }

    public String getOriginalPageRestrictionsJSON() {
        return this.getActiveObject().getOriginalRestrictionsJSON();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public Space getSpace() {
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public String getSpaceName() {
        return Confluence.getSpaceName(this.getSpaceKey());
    }

    public void removeFromPage() {
        PageRestricter pageRestricter = new PageRestricter(this.getActiveObjects(), this.getAbstractPage());
        pageRestricter.unrestrictForPublishingWorkflow();
        this.delete();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(RestrictedPageAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setOriginalPageRestrictionsJSON(String originalRestrictionsJSON) {
        this.getActiveObject().setOriginalRestrictionsJSON(originalRestrictionsJSON);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }
}

