/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.user.User;
import com.brikit.contentflow.model.ApprovalStatus;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.PageApprovalStep;
import com.brikit.contentflow.model.PageReviewFeedback;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.contentflow.model.UserDelegate;
import com.brikit.contentflow.model.ao.PageReviewFeedbackAO;
import com.brikit.contentflow.model.query.PageReviewFeedbackQuery;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.Email;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.java.ao.RawEntity;

public class PageReviewer {
    protected Reviewer reviewer;
    protected PageApprovalStep pageApprovalStep;
    protected BrikitList<PageReviewFeedback> pageReviewFeedback;
    protected ActiveObjects activeObjects;

    public PageReviewer(ActiveObjects activeObjects, Reviewer reviewer, PageApprovalStep pageApprovalStep) {
        this.reviewer = reviewer;
        this.pageApprovalStep = pageApprovalStep;
        this.activeObjects = activeObjects;
    }

    protected static BrikitList<PageReviewFeedback> fromActiveObjects(ActiveObjects activeObjects, PageReviewFeedbackAO[] pageReviewFeedbackAOs) {
        BrikitList<PageReviewFeedback> pageReviewFeedback = new BrikitList<PageReviewFeedback>();
        for (PageReviewFeedbackAO pageReviewFeedbackAO : pageReviewFeedbackAOs) {
            pageReviewFeedback.add(new PageReviewFeedback(activeObjects, pageReviewFeedbackAO));
        }
        return pageReviewFeedback;
    }

    protected void addApprovalComment(LocalNotificationService notificationService, String optionalComment) {
        this.addReviewerFeedback(optionalComment, ApprovalStatus.APPROVED);
        if (this.getPageApprovalStep().isComplete()) {
            this.notifyReviewers(notificationService, this.getPageApprovalStep().nextStep());
        }
    }

    protected void addRejectionComment(LocalNotificationService notificationService, String optionalComment) {
        this.addReviewerFeedback(optionalComment, ApprovalStatus.REJECTED);
        this.notifyReviewers(notificationService, this.getPageApprovalStep().previousStep());
    }

    protected void addResetFeedbackComment(LocalNotificationService notificationService, String optionalComment) {
        if (this.getLastReviewerFeedback() != null) {
            this.addReviewerFeedback(optionalComment, ApprovalStatus.RESET);
        }
    }

    protected PageReviewFeedback addReviewerFeedback(String commentString, ApprovalStatus approvalStatus) {
        return PageReviewFeedback.create(this.getActiveObjects(), this.getAbstractPage(), this, commentString, approvalStatus);
    }

    protected void addUserAndDelegateToList(List<ConfluenceUser> users, User user) {
        if (user == null) {
            return;
        }
        ConfluenceUser confluenceUser = user instanceof ConfluenceUser ? (ConfluenceUser)user : Confluence.getConfluenceUser(user.getName());
        users.add(confluenceUser);
        UserDelegate delegate = UserDelegate.getUserDelegateForDelegatingUser(this.getActiveObjects(), confluenceUser);
        if (delegate != null) {
            users.add(delegate.getDelegate());
        }
    }

    public void approve(LocalNotificationService notificationService, String userComment) {
        this.addApprovalComment(notificationService, userComment);
        this.getPageApprovalStep().reviewerApproved(notificationService, this);
    }

    public void clearReviewerFeedback(LocalNotificationService notificationService) {
        this.addResetFeedbackComment(notificationService, null);
    }

    protected void createConfluenceNotification(LocalNotificationService notificationService, ConfluenceUser user) throws ExecutionException, InterruptedException {
        Notification notification = (Notification)notificationService.createOrUpdate(user.getName(), new NotificationBuilder().application("com.brikit.contentflow").title(Confluence.getText("com.brikit.contentflow.notification.approval.needed.message")).entity(this.getAbstractPage().getDisplayTitle()).itemTitle(Confluence.getText("com.brikit.contentflow.notification.approval.needed.title", new Object[]{this.getAbstractPage().getDisplayTitle()})).description("<h2>" + Confluence.getPageLinkHTML(this.getAbstractPage()) + "</h2>").groupingId(this.getAbstractPage().getIdAsString()).createNotification()).get();
    }

    public void delete() {
        PageReviewFeedbackAO[] pageReviewFeedbackAOs;
        PageReviewFeedbackQuery query = new PageReviewFeedbackQuery(this.getActiveObjects());
        for (PageReviewFeedbackAO pageReviewFeedbackAO : pageReviewFeedbackAOs = query.getPageReviewFeedbackForPageAndReviewer(this.getAbstractPage(), this.getPageApprovalStep().getPageWorkflow(), this.getReviewer().getActiveObject())) {
            this.getActiveObjects().delete(new RawEntity[]{pageReviewFeedbackAO});
        }
    }

    protected void forceApproval() {
        if (this.isApproved()) {
            return;
        }
        PageReviewFeedback.create(this.getActiveObjects(), this.getAbstractPage(), this, Confluence.getText("com.brikit.contentflow.admin.forced.approval"), ApprovalStatus.APPROVED);
    }

    public AbstractPage getAbstractPage() {
        return this.getPageApprovalStep().getAbstractPage();
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public ApprovalStep getApprovalStep() {
        return this.getPageApprovalStep().getApprovalStep();
    }

    public PageReviewFeedback getLastReviewerFeedback() {
        return this.getPageReviewFeedback().last();
    }

    public PageApprovalStep getPageApprovalStep() {
        return this.pageApprovalStep;
    }

    public BrikitList<PageReviewFeedback> getPageReviewFeedback() {
        if (this.pageReviewFeedback == null) {
            PageReviewFeedbackQuery query = new PageReviewFeedbackQuery(this.getActiveObjects());
            PageReviewFeedbackAO[] pageReviewFeedbackAOs = query.getPageReviewFeedbackForPageAndReviewer(this.getAbstractPage(), this.getPageApprovalStep().getPageWorkflow(), this.getReviewer().getActiveObject());
            this.pageReviewFeedback = PageReviewer.fromActiveObjects(this.getActiveObjects(), pageReviewFeedbackAOs);
            Collections.sort(this.pageReviewFeedback, PageReviewFeedback.DateOrder);
            this.pageReviewFeedback = new BrikitList<PageReviewFeedback>((List<PageReviewFeedback>)this.pageReviewFeedback);
        }
        return this.pageReviewFeedback;
    }

    public Reviewer getReviewer() {
        return this.reviewer;
    }

    public boolean isApproved() {
        return this.getLastReviewerFeedback() != null && this.getLastReviewerFeedback().isApproved();
    }

    public boolean isRejected() {
        return this.getLastReviewerFeedback() != null && this.getLastReviewerFeedback().isRejected();
    }

    public boolean isReset() {
        return this.getLastReviewerFeedback() != null && this.getLastReviewerFeedback().isReset();
    }

    public boolean isWaitingForUser() {
        return !this.isApproved() && !this.isRejected();
    }

    protected void notifyReviewers(LocalNotificationService notificationService, PageApprovalStep pageApprovalStep) {
        if (pageApprovalStep == null || pageApprovalStep.getApprovalStep() == null) {
            return;
        }
        for (Reviewer reviewer : pageApprovalStep.getApprovalStep().getReviewers()) {
            ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
            if (BrikitString.isSet(reviewer.getGroupName())) {
                for (User user : Confluence.getGroupMembers(reviewer.getGroupName())) {
                    this.addUserAndDelegateToList(users, user);
                }
            } else {
                this.addUserAndDelegateToList(users, (User)reviewer.getUser());
            }
            try {
                for (ConfluenceUser confluenceUser : users) {
                    this.createConfluenceNotification(notificationService, confluenceUser);
                    this.sendEmail(confluenceUser);
                }
            }
            catch (Exception ex) {
                BrikitLog.logError("Unable to create Confluence notification for " + reviewer.getUser() + " on " + this.getAbstractPage());
            }
        }
    }

    public void reject(LocalNotificationService notificationService, String userComment) {
        this.addRejectionComment(notificationService, userComment);
        this.getPageApprovalStep().reviewerRejected(notificationService, this);
    }

    protected void removeResets() {
        for (PageReviewFeedback pageReviewFeedback : this.getPageReviewFeedback()) {
            if (!pageReviewFeedback.isReset()) continue;
            pageReviewFeedback.delete();
        }
    }

    protected void sendEmail(ConfluenceUser user) {
        try {
            Email email = new Email();
            email.setTo(user.getEmail());
            email.setSubject(Confluence.getText("com.brikit.contentflow.notification.approval.needed.title", new Object[]{this.getAbstractPage().getDisplayTitle()}));
            email.setHtml(true);
            email.setBody("<p>" + Confluence.getText("com.brikit.contentflow.notification.approval.needed.message") + "</p><h2><a href='" + Confluence.getBaseUrl() + Confluence.getPageURL(this.getAbstractPage()) + "'>" + this.getAbstractPage().getDisplayTitle() + "</a></h2>");
            email.send();
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to send email notifications for " + user + " on " + this.getAbstractPage());
        }
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void undoApprove(LocalNotificationService notificationService) {
        if (this.getPageApprovalStep().getPageWorkflow().isComplete()) {
            return;
        }
        this.getLastReviewerFeedback().delete();
        this.getPageApprovalStep().reviewerUndidApprove(notificationService, this);
    }

    public void undoReject(LocalNotificationService notificationService) {
        this.getLastReviewerFeedback().delete();
        this.getPageApprovalStep().reviewerUndidReject(this);
    }
}

