/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.contentflow.model.ContentFlowUtils;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Publisher;
import com.brikit.contentflow.model.RestrictedPage;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.contentflow.model.Workflow;
import com.brikit.core.confluence.Confluence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageRestricter {
    protected ActiveObjects activeObjects;
    protected AbstractPage abstractPage;

    public PageRestricter(ActiveObjects activeObjects, AbstractPage abstractPage) {
        this.activeObjects = activeObjects;
        this.abstractPage = abstractPage;
    }

    public AbstractPage getAbstractPage() {
        return this.abstractPage;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public boolean hasPageAnyRestrictions() {
        ContentPermissionSet viewPermissionSet = Confluence.getPageViewRestrictions(this.getAbstractPage());
        ContentPermissionSet editPermissionSet = Confluence.getPageEditRestrictions(this.getAbstractPage());
        return viewPermissionSet != null && !viewPermissionSet.isEmpty() || editPermissionSet != null && !editPermissionSet.isEmpty();
    }

    public boolean hasPageViewRestrictions() {
        ContentPermissionSet permissionSet = Confluence.getPageViewRestrictions(this.getAbstractPage());
        return permissionSet != null && !permissionSet.isEmpty();
    }

    protected boolean isNewPageUnderAutomaticPublishingWorkflow() {
        return Publisher.isNewPageUnderAutomaticPublishingWorkflow(this.getActiveObjects(), this.getAbstractPage());
    }

    public void restrictForPublishingWorkflow(PageWorkflow pageWorkflow) {
        RestrictedPage restrictedPage = RestrictedPage.getRestrictedPage(this.getActiveObjects(), this.getAbstractPage());
        if (restrictedPage == null) {
            restrictedPage = RestrictedPage.create(this.getActiveObjects(), this.getAbstractPage());
        }
        ContentPermissionSet permissionSet = restrictedPage.getOriginalPageRestrictions();
        List<ContentPermission> permissionsToAdd = this.viewRestrictionsForAutomaticPublishingWorkflow(pageWorkflow.getWorkflow());
        for (ContentPermission permission : permissionsToAdd) {
            permissionSet.addContentPermission(permission);
        }
        this.setViewPermissions(this.getAbstractPage(), permissionSet);
    }

    public void restrictForScheduling() {
        if (this.isNewPageUnderAutomaticPublishingWorkflow()) {
            return;
        }
        ContentPermissionSet viewPermissionSet = ContentFlowUtils.getOpenViewPermissions(this.getAbstractPage());
        for (ContentPermission permission : this.viewRestrictionsForEditors()) {
            viewPermissionSet.addContentPermission(permission);
        }
        this.setViewPermissions(this.getAbstractPage(), viewPermissionSet);
        ContentPermissionSet editPermissionSet = ContentFlowUtils.getOpenEditPermissions(this.getAbstractPage());
        this.setEditPermissions(this.getAbstractPage(), editPermissionSet);
    }

    protected void setEditPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        ContentFlowUtils.setEditPermissions(this.getAbstractPage(), permissionSet);
    }

    protected void setViewPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        ContentFlowUtils.setViewPermissions(this.getAbstractPage(), permissionSet);
    }

    public void unrestrictForPublishingWorkflow() {
        RestrictedPage restrictedPage = RestrictedPage.getRestrictedPage(this.getActiveObjects(), this.getAbstractPage());
        if (restrictedPage == null) {
            return;
        }
        this.setViewPermissions(this.getAbstractPage(), restrictedPage.getOriginalPageRestrictions());
    }

    public void unrestrictForScheduling() {
        if (this.isNewPageUnderAutomaticPublishingWorkflow()) {
            return;
        }
        ContentFlowUtils.setViewPermissions(this.getAbstractPage(), null);
    }

    protected List<ContentPermission> viewRestrictionsForAutomaticPublishingWorkflow(Workflow workflow) {
        List<ContentPermission> permissions = this.viewRestrictionsForEditors();
        for (Reviewer reviewer : workflow.getAllReviewers()) {
            ContentPermission permission = null;
            if (reviewer.getUser() != null) {
                permission = ContentPermission.createUserPermission((String)"View", (ConfluenceUser)reviewer.getUser());
            } else if (reviewer.specifiesGroup()) {
                permission = ContentPermission.createGroupPermission((String)"View", (String)reviewer.getGroupName());
            }
            if (permission == null) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    protected List<ContentPermission> viewRestrictionsForEditors() {
        ArrayList<ContentPermission> permissions = new ArrayList<ContentPermission>();
        SpacePermissionManager permissionManager = Confluence.getSpacePermissionManager();
        Space space = Confluence.getSpace(this.getAbstractPage());
        String editPermission = Confluence.isPage(this.getAbstractPage()) ? "EDITSPACE" : "EDITBLOG";
        Map permittedUsers = permissionManager.getUsersForPermissionType(editPermission, space);
        Map permittedGroups = permissionManager.getGroupsForPermissionType(editPermission, space);
        for (String userKey : permittedUsers.keySet()) {
            ConfluenceUser permittedUser = Confluence.getConfluenceUserByUserKey(userKey);
            if (permittedUser == null) continue;
            permissions.add(ContentPermission.createUserPermission((String)"View", (ConfluenceUser)permittedUser));
        }
        for (String groupKey : permittedGroups.keySet()) {
            permissions.add(ContentPermission.createGroupPermission((String)"View", (String)groupKey));
        }
        return permissions;
    }
}

