/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.SpaceActivity;
import com.brikit.contentflow.model.ao.LastSpaceViewAO;
import com.brikit.contentflow.model.query.LastSpaceViewQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class LastSpaceView
extends AbstractActiveObjectsModel {
    public static Comparator<LastSpaceView> DateOrder = new Comparator<LastSpaceView>(){

        @Override
        public int compare(LastSpaceView lastSpaceView1, LastSpaceView lastSpaceView2) {
            return lastSpaceView1.getDate().compareTo(lastSpaceView2.getDate());
        }
    };
    public static Comparator<LastSpaceView> SpaceOrder = new Comparator<LastSpaceView>(){

        @Override
        public int compare(LastSpaceView lastSpaceView1, LastSpaceView lastSpaceView2) {
            Space space1 = Confluence.getSpace(lastSpaceView1.getSpaceKey());
            Space space2 = Confluence.getSpace(lastSpaceView2.getSpaceKey());
            String spaceName1 = space1 == null ? "" : space1.getName();
            String spaceName2 = space2 == null ? "" : space2.getName();
            int result = spaceName1.compareToIgnoreCase(spaceName2);
            return result == 0 ? lastSpaceView1.getDate().compareTo(lastSpaceView2.getDate()) : result;
        }
    };
    protected LastSpaceViewAO activeObject;

    protected LastSpaceView(ActiveObjects activeObjects, LastSpaceViewAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static LastSpaceView create(ActiveObjects activeObjects, String spaceKey) {
        LastSpaceViewAO LastSpaceViewAO2 = (LastSpaceViewAO)activeObjects.create(LastSpaceViewAO.class, new DBParam[0]);
        LastSpaceViewAO2.setSpaceKey(spaceKey);
        LastSpaceView lastSpaceView = new LastSpaceView(activeObjects, LastSpaceViewAO2);
        lastSpaceView.save();
        return lastSpaceView;
    }

    protected static BrikitList<LastSpaceView> fromActiveObjects(ActiveObjects activeObjects, LastSpaceViewAO[] LastSpaceViewAOs) {
        BrikitList<LastSpaceView> spaceActivities = new BrikitList<LastSpaceView>(LastSpaceViewAOs.length);
        for (LastSpaceViewAO LastSpaceViewAO2 : LastSpaceViewAOs) {
            spaceActivities.add(new LastSpaceView(activeObjects, LastSpaceViewAO2));
        }
        return spaceActivities;
    }

    public static LastSpaceView getLastSpaceView(ActiveObjects activeObjects, String spaceKey) {
        LastSpaceViewQuery query = new LastSpaceViewQuery(activeObjects);
        LastSpaceViewAO LastSpaceViewAO2 = query.getLastSpaceView(spaceKey);
        return LastSpaceViewAO2 == null ? null : new LastSpaceView(activeObjects, LastSpaceViewAO2);
    }

    public static LastSpaceView getOrCreateLastSpaceView(ActiveObjects activeObjects, String spaceKey) {
        LastSpaceView lastSpaceView = LastSpaceView.getLastSpaceView(activeObjects, spaceKey);
        if (lastSpaceView == null) {
            lastSpaceView = LastSpaceView.create(activeObjects, spaceKey);
        }
        return lastSpaceView;
    }

    public static BrikitList<LastSpaceView> getSpacesNotViewedInDays(ActiveObjects activeObjects, int days) {
        LastSpaceViewQuery query = new LastSpaceViewQuery(activeObjects);
        return LastSpaceView.fromActiveObjects(activeObjects, query.getSpacesNotViewedInDays(days));
    }

    public static Calendar lastViewed(ActiveObjects activeObjects, String spaceKey) {
        LastSpaceView lastSpaceView = LastSpaceView.getLastSpaceView(activeObjects, spaceKey);
        return lastSpaceView == null ? SpaceActivity.lastViewed(activeObjects, spaceKey) : lastSpaceView.getDate();
    }

    public static void spaceViewed(ActiveObjects activeObjects, String spaceKey, Calendar date) {
        LastSpaceView lastSpaceView = LastSpaceView.getOrCreateLastSpaceView(activeObjects, spaceKey);
        if (lastSpaceView.getDate() == null || BrikitDate.isAfter(date, lastSpaceView.getDate())) {
            lastSpaceView.setDate(date);
            lastSpaceView.save();
        }
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public LastSpaceViewAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getDate() {
        return BrikitDate.toCalendar(this.getActiveObject().getDate());
    }

    public int getDaysSinceLastViewed() {
        return BrikitDate.daysBetween(this.getDate(), BrikitDate.getTodayDateOnly());
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public Space getSpace() {
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(LastSpaceViewAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setDate(Calendar date) {
        this.setDate(date.getTime());
    }

    public void setDate(Date date) {
        this.getActiveObject().setDate(date);
    }
}

