/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.PageActivity;
import com.brikit.contentflow.model.ao.LastPageViewAO;
import com.brikit.contentflow.model.query.LastPageViewQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class LastPageView
extends AbstractActiveObjectsModel {
    public static Comparator<LastPageView> DateOrder = new Comparator<LastPageView>(){

        @Override
        public int compare(LastPageView lastPageView1, LastPageView lastPageView2) {
            return lastPageView1.getDate().compareTo(lastPageView2.getDate());
        }
    };
    public static Comparator<LastPageView> PageOrder = new Comparator<LastPageView>(){

        @Override
        public int compare(LastPageView lastPageView1, LastPageView lastPageView2) {
            int result = new Long(lastPageView1.getPageId()).compareTo(new Long(lastPageView2.getPageId()));
            return result == 0 ? lastPageView1.getDate().compareTo(lastPageView2.getDate()) : result;
        }
    };
    protected LastPageViewAO activeObject;

    protected LastPageView(ActiveObjects activeObjects, LastPageViewAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static LastPageView create(ActiveObjects activeObjects, long pageId) {
        LastPageViewAO lastPageViewAO = (LastPageViewAO)activeObjects.create(LastPageViewAO.class, new DBParam[0]);
        lastPageViewAO.setPageId(pageId);
        lastPageViewAO.setSpaceKey(Confluence.getSpaceKey(pageId));
        LastPageView lastPageView = new LastPageView(activeObjects, lastPageViewAO);
        lastPageView.save();
        return lastPageView;
    }

    protected static BrikitList<LastPageView> fromActiveObjects(ActiveObjects activeObjects, LastPageViewAO[] lastPageViewAOs) {
        BrikitList<LastPageView> pageActivities = new BrikitList<LastPageView>(lastPageViewAOs.length);
        for (LastPageViewAO lastPageViewAO : lastPageViewAOs) {
            pageActivities.add(new LastPageView(activeObjects, lastPageViewAO));
        }
        return pageActivities;
    }

    public static LastPageView getLastPageView(ActiveObjects activeObjects, long pageId) {
        LastPageViewQuery query = new LastPageViewQuery(activeObjects);
        LastPageViewAO lastPageViewAO = query.getLastPageView(pageId);
        return lastPageViewAO == null ? null : new LastPageView(activeObjects, lastPageViewAO);
    }

    public static LastPageView getOrCreateLastPageView(ActiveObjects activeObjects, long pageId) {
        LastPageView lastPageView = LastPageView.getLastPageView(activeObjects, pageId);
        if (lastPageView == null) {
            lastPageView = LastPageView.create(activeObjects, pageId);
        }
        return lastPageView;
    }

    public static BrikitList<LastPageView> getPagesNotViewedInDays(ActiveObjects activeObjects, String spaceKey, int days) {
        LastPageViewQuery query = new LastPageViewQuery(activeObjects);
        return LastPageView.fromActiveObjects(activeObjects, query.getPagesNotViewedInDays(spaceKey, days));
    }

    public static Calendar lastViewed(ActiveObjects activeObjects, long pageId) {
        LastPageView lastPageView = LastPageView.getLastPageView(activeObjects, pageId);
        return lastPageView == null ? PageActivity.lastViewed(activeObjects, pageId) : lastPageView.getDate();
    }

    public static void pageViewed(ActiveObjects activeObjects, long pageId, Calendar date) {
        LastPageView lastPageView = LastPageView.getOrCreateLastPageView(activeObjects, pageId);
        if (lastPageView.getDate() == null || BrikitDate.isAfter(date, lastPageView.getDate())) {
            lastPageView.setDate(date);
            lastPageView.save();
        }
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public LastPageViewAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getDate() {
        return BrikitDate.toCalendar(this.getActiveObject().getDate());
    }

    public int getDaysSinceLastViewed() {
        return BrikitDate.daysBetween(this.getDate(), BrikitDate.getTodayDateOnly());
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public Space getSpace() {
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(LastPageViewAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setDate(Calendar date) {
        this.setDate(date.getTime());
    }

    public void setDate(Date date) {
        this.getActiveObject().setDate(date);
    }
}

