/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ContentFlowProperties {
    public static final String RESOURCE_FOLDER = "content-flows";
    public static final String COMMENTS_PROPERTIES_FILE = "comments.properties";
    public static final String PLUGIN_KEY = "com.brikit.contentflow";

    public static String get(String key) {
        return ContentFlowProperties.getProperties().getProperty(key);
    }

    protected static Properties getProperties() {
        return BrikitFile.readProperties(ContentFlowProperties.getContentFlowPropertiesFile());
    }

    public static File getContentFlowPropertiesFile() {
        File propertiesFile = new File(ContentFlowProperties.getPropertiesLocation(), COMMENTS_PROPERTIES_FILE);
        if (!propertiesFile.exists()) {
            try {
                BrikitFile.ensurePathExists(ContentFlowProperties.getPropertiesLocation());
                propertiesFile.createNewFile();
            }
            catch (IOException ex) {
                BrikitLog.logError("Unable to create the Content Flow properties file.", ex);
            }
        }
        return propertiesFile;
    }

    public static File getPropertiesLocation() {
        return new File(Confluence.getConfluenceHome(), RESOURCE_FOLDER);
    }
}

