/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.brikit.contentflow.model.Archiver;
import com.brikit.contentflow.model.ao.ArchivedPageAO;
import com.brikit.contentflow.model.query.ArchivedPageQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitNumber;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class ArchivedPage
extends AbstractActiveObjectsModel
implements Comparable {
    protected ArchivedPageAO activeObject;
    protected Archiver archiver;

    public ArchivedPage(ActiveObjects activeObjects, ArchivedPageAO activeObject) {
        super(activeObjects);
        this.activeObject = activeObject;
    }

    public static ArchivedPage create(ActiveObjects activeObjects, String pageIdAsString) {
        return ArchivedPage.create(activeObjects, Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static ArchivedPage create(ActiveObjects activeObjects, AbstractPage abstractPage) {
        Page parent;
        ArchivedPageAO archivedPageAO = (ArchivedPageAO)activeObjects.create(ArchivedPageAO.class, new DBParam[0]);
        archivedPageAO.setPageId(abstractPage.getId());
        archivedPageAO.setDateArchived(BrikitDate.toDate(Confluence.getSystemTimeNow()));
        archivedPageAO.setOriginalSpaceKey(abstractPage.getSpaceKey());
        if (abstractPage instanceof Page && (parent = ((Page)abstractPage).getParent()) != null) {
            archivedPageAO.setOriginalParentPageId(parent.getId());
        }
        ArchivedPage archivedPage = new ArchivedPage(activeObjects, archivedPageAO);
        archivedPage.save();
        return archivedPage;
    }

    protected static List<ArchivedPage> fromActiveObjects(ActiveObjects activeObjects, ArchivedPageAO[] archivedPageAOs) {
        ArrayList<ArchivedPage> archivedPages = new ArrayList<ArchivedPage>(archivedPageAOs.length);
        for (ArchivedPageAO archivedPageAO : archivedPageAOs) {
            archivedPages.add(new ArchivedPage(activeObjects, archivedPageAO));
        }
        return archivedPages;
    }

    public static ArchivedPage getArchivedPageForPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return ArchivedPage.getArchivedPageForPage(activeObjects, abstractPage.getId());
    }

    public static ArchivedPage getArchivedPageForPage(ActiveObjects activeObjects, long pageId) {
        ArchivedPageAO archivedPageAO = ArchivedPage.getArchivedPageAO(activeObjects, pageId);
        return archivedPageAO == null ? null : new ArchivedPage(activeObjects, archivedPageAO);
    }

    public static ArchivedPage getArchivedPageForPage(ActiveObjects activeObjects, String pageIdAsString) {
        return ArchivedPage.getArchivedPageForPage(activeObjects, BrikitNumber.longValue(pageIdAsString));
    }

    protected static ArchivedPageAO getArchivedPageAO(ActiveObjects activeObjects, long pageId) {
        ArchivedPageQuery query = new ArchivedPageQuery(activeObjects);
        return query.getArchivedPageForPage(pageId);
    }

    public static List<ArchivedPage> getArchivedPages(ActiveObjects activeObjects, String spaceKey) {
        ArchivedPageQuery query = new ArchivedPageQuery(activeObjects);
        return ArchivedPage.fromActiveObjects(activeObjects, query.getArchivedPages(spaceKey));
    }

    public int compareTo(Object o) {
        String title1 = this.getAbstractPage().getTitle();
        String title2 = ((ArchivedPage)o).getAbstractPage().getTitle();
        return Collator.getInstance().compare(title1 == null ? "" : title1, title2 == null ? "" : title2);
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public ArchivedPageAO getActiveObject() {
        return this.activeObject;
    }

    @Override
    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public Calendar getDateArchived() {
        Date date = this.getActiveObject().getDateArchived();
        return date == null ? null : BrikitDate.toCalendar(date);
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public Calendar getLastModificationDate() {
        return BrikitDate.toCalendar(this.getAbstractPage().getLastModificationDate());
    }

    public AbstractPage getOriginalParentPage() {
        return Confluence.getPageOrBlogPost(this.getOriginalParentPageId());
    }

    public long getOriginalParentPageId() {
        return this.getActiveObject().getOriginalParentPageId();
    }

    public String getOriginalSpaceKey() {
        return this.getActiveObject().getOriginalSpaceKey();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setDateArchived(Calendar dateArchived) {
        this.setDateArchived(BrikitDate.toDate(dateArchived));
    }

    public void setDateArchived(Date dateArchived) {
        this.getActiveObject().setDateArchived(dateArchived);
    }

    public void setOriginalParentPageId(long originalParentId) {
        this.getActiveObject().setOriginalParentPageId(originalParentId);
    }

    public void setOriginalSpaceKey(String spaceKey) {
        this.getActiveObject().setOriginalSpaceKey(spaceKey);
    }

    public void unarchive() {
        if (!this.getAbstractPage().isDeleted()) {
            Archiver.unarchiveFromArchiveSpace(this);
        } else {
            Confluence.restorePage(this.getAbstractPage());
        }
        this.delete();
    }
}

