/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.listeners;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.brikit.contentflow.model.PageInReview;
import com.brikit.contentflow.model.PageWorkflow;
import org.springframework.beans.factory.DisposableBean;

public class ContentUpdateListener
implements DisposableBean {
    protected EventPublisher eventPublisher;
    protected ActiveObjects activeObjects;

    public ContentUpdateListener(EventPublisher eventPublisher, ActiveObjects activeObjects) {
        this.eventPublisher = eventPublisher;
        this.activeObjects = activeObjects;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        PageWorkflow.created(this.getActiveObjects(), (AbstractPage)event.getPage());
    }

    @EventListener
    public void blogPostCreateEvent(BlogPostCreateEvent event) {
        PageWorkflow.created(this.getActiveObjects(), (AbstractPage)event.getBlogPost());
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        PageWorkflow.updated(this.getActiveObjects(), (AbstractPage)event.getPage());
        PageInReview.updated(this.getActiveObjects(), (AbstractPage)event.getPage());
    }

    @EventListener
    public void blogPostUpdateEvent(BlogPostUpdateEvent event) {
        PageWorkflow.updated(this.getActiveObjects(), (AbstractPage)event.getBlogPost());
        PageInReview.updated(this.getActiveObjects(), (AbstractPage)event.getBlogPost());
    }

    @EventListener
    public void pageRemoveEvent(PageRemoveEvent event) {
        PageWorkflow.removed(this.getActiveObjects(), (AbstractPage)event.getPage());
        PageInReview.removed(this.getActiveObjects(), (AbstractPage)event.getPage());
    }

    @EventListener
    public void blogPostRemoveEvent(BlogPostRemoveEvent event) {
        PageWorkflow.removed(this.getActiveObjects(), (AbstractPage)event.getBlogPost());
        PageInReview.removed(this.getActiveObjects(), (AbstractPage)event.getBlogPost());
    }

    @EventListener
    public void pageRestoreEvent(PageRestoreEvent event) {
        PageWorkflow.restored(this.getActiveObjects(), (AbstractPage)event.getPage());
    }

    @EventListener
    public void blogPostRestoreEvent(BlogPostRestoreEvent event) {
        PageWorkflow.restored(this.getActiveObjects(), (AbstractPage)event.getBlogPost());
    }

    @EventListener
    public void attachmentUpdateEvent(AttachmentUpdateEvent event) {
        ContentEntityObject ceo = event.getAttachedTo();
        if (ceo instanceof AbstractPage) {
            PageWorkflow.updated(this.getActiveObjects(), (AbstractPage)ceo);
            PageInReview.updated(this.getActiveObjects(), (AbstractPage)ceo);
        }
    }

    @EventListener
    public void attachmentTrashedEvent(AttachmentTrashedEvent event) {
        ContentEntityObject ceo = event.getAttachedTo();
        if (ceo instanceof AbstractPage) {
            PageWorkflow.updated(this.getActiveObjects(), (AbstractPage)ceo);
            PageInReview.updated(this.getActiveObjects(), (AbstractPage)ceo);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }
}

