/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.jobs;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.brikit.contentflow.model.ContentFlow;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractContentFlowJob
implements Job {
    public static final String JOB_USERNAME = "com.brikit.contentflow.job.username";
    protected ActiveObjects activeObjects;
    protected TransactionTemplate transactionTemplate;
    protected LocalNotificationService notificationService;
    protected PluginLicenseManager pluginLicenseManager;

    public static String getJobUsername() {
        String username = (String)Confluence.getBandanaManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, JOB_USERNAME);
        if (!BrikitString.isSet(username)) {
            username = Confluence.findAnyConfluenceAdministrator().getName();
        }
        return username;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void insideTransaction() {
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                AbstractContentFlowJob.this.insideTransaction();
                return null;
            }
        });
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public LocalNotificationService getNotificationService() {
        return this.notificationService;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public boolean isLicensed() {
        return ContentFlow.isLicensed(this.getPluginLicenseManager());
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void setNotificationService(LocalNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public static void setJobUsername(String username) {
        Confluence.getBandanaManager().setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, JOB_USERNAME, (Object)username);
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

