/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.context;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.contentflow.model.ContentOwner;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.contentflow.model.PageCommentCount;
import com.brikit.contentflow.model.PageDescendantCount;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.settings.DocumentIdentifierSettings;
import com.brikit.contentflow.settings.PublishDateManager;
import com.brikit.core.confluence.Confluence;
import java.util.Calendar;

public class ContentFlowVelocityContext {
    protected ActiveObjects activeObjects;

    public static synchronized void addUserToIgnoreList(String username) {
        PageWorkflow.addUserToIgnoreList(username);
    }

    public void applyWorkflow(Integer workflowId, AbstractPage abstractPage, Boolean newPage) {
        PageWorkflow.applyWorkflow(this.getActiveObjects(), workflowId, abstractPage, newPage);
    }

    public String documentIdentifier(Page page) {
        return DocumentIdentifiers.composeDocumentIdentifier((AbstractPage)page);
    }

    public String formatPublishDate(AbstractPage abstractPage, String dateFormat) {
        return PublishDateManager.formatPublishDate(abstractPage, dateFormat);
    }

    public String formatPublishDate(AbstractPage abstractPage) {
        return this.formatPublishDate(abstractPage, null);
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public Integer getActiveWorkflowId(AbstractPage abstractPage) {
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(this.getActiveObjects(), abstractPage);
        return pageWorkflow == null ? null : Integer.valueOf(pageWorkflow.getWorkflow().getID());
    }

    public boolean isDocumentIdentifiersEnabledForSpace(String spaceKey) {
        return DocumentIdentifierSettings.isDocumentIdentifiersEnabledForSpace(spaceKey);
    }

    public boolean isWorkflowAvailable(int workflowId, String spaceKey) {
        return Workflow.isWorkflowAvailable(this.getActiveObjects(), workflowId, spaceKey);
    }

    public long pageCommentCount(AbstractPage abstractPage) {
        return PageCommentCount.commentCount(abstractPage);
    }

    public ConfluenceUser pageContentOwner(AbstractPage abstractPage) {
        ContentOwner contentOwner = ContentOwner.getContentOwner(this.getActiveObjects(), abstractPage.getId());
        return contentOwner == null ? abstractPage.getCreator() : contentOwner.getUser();
    }

    public long pageDescendantCount(AbstractPage abstractPage, boolean immediateChildren) {
        return PageDescendantCount.descendantCount(abstractPage, immediateChildren);
    }

    public PageStatus pageStatus(AbstractPage abstractPage) {
        return PageStatus.getPageStatusForPage(this.getActiveObjects(), abstractPage);
    }

    public Calendar publishDate(AbstractPage abstractPage) {
        return PublishDateManager.getPublishDate(abstractPage);
    }

    public static synchronized void removeUserFromIgnoreList(String username) {
        PageWorkflow.removeUserFromIgnoreList(username);
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public ConfluenceUser spaceContentOwner(AbstractPage abstractPage) {
        ContentOwner contentOwner = ContentOwner.getContentOwner(this.getActiveObjects(), Confluence.getSpaceKey(abstractPage));
        return contentOwner == null ? null : contentOwner.getUser();
    }

    public ConfluenceUser spaceContentOwner(String spaceKey) {
        ContentOwner contentOwner = ContentOwner.getContentOwner(this.getActiveObjects(), spaceKey);
        return contentOwner == null ? null : contentOwner.getUser();
    }

    public Workflow workflowWithId(int workflowId) {
        return Workflow.getWorkflowWithId(this.getActiveObjects(), workflowId);
    }
}

