/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.settings.PublishDateManager;
import com.brikit.core.util.BrikitDate;
import java.text.ParseException;
import java.util.Calendar;

public class PublishDateMetadataAction
extends ContentFlowActionSupport {
    protected String publishDate;

    @Override
    public String execute() throws Exception {
        Calendar publishDate = PublishDateManager.getPublishDate(this.getPage());
        if (publishDate != null) {
            this.setPublishDate(BrikitDate.formatSimpleDate(publishDate));
        }
        return super.execute();
    }

    public String getPublishDate() {
        return this.publishDate;
    }

    public String savePublishDate() {
        try {
            PublishDateManager.setPublishDate(this.getPage(), this.getPublishDate());
        }
        catch (ParseException ex) {
            this.addActionError(this.getText("com.brikit.contentflow.invalidate.publish.date.format"));
            return "error";
        }
        return "success";
    }

    public void setPublishDate(String publishDate) {
        this.publishDate = publishDate;
    }
}

