(function ($) {
	
	ContentFlowPageStatusBanner = function (trigger) {
		this.trigger = $(trigger);
		this.trigger.data("page-info-status", this);
		this.debug = false;
		this.initialize();
	};
	
	Object.assign(ContentFlowPageStatusBanner.prototype, {
		
		// Inline dialogs cause the trigger to get the active class, and closing the dialog doesn't clear it
		// This pauses to allow the dialog to display before removing the class
		deactivateTrigger: function () {
			setTimeout(function () { this.trigger.removeClass("active");}.bind(this), 500);
			
		},
		
		initialize: function () {
			this.id = "page-info-status-dropdown";
			if (this.trigger.data("macro-id")) this.id += "-" + this.trigger.data("macro-id");

			var data = { pageId: ContentFlow.pageId };
			if (ContentFlow.urlParams["published"] == "true") data.published = true;
			$.ajax({
				type: "GET",
				url: ContentFlow.contextPath + "/plugins/contentflow/pageinfobanner.action",
				data: data,
				dataType: "json",
				success:  this.loadMenu.bind(this)
			});
			
			this.trigger.append($("<span>").addClass("aui-icon aui-icon-small").spin());
			
			$("body")
				.on("click", "#" + this.id + " .unlicensed-link", this.openUnlicensedDialog.bind(this))
				.on("click", "#" + this.id + " .apply-workflow-trigger", this.openApplyWorkflowDialog.bind(this))
				.on("click", "#" + this.id + " .approve-workflow-trigger", this.openApproveWorkflowDialog.bind(this))
				.on("click", "#" + this.id + " .view-workflow-trigger", this.openApproveWorkflowDialog.bind(this))
				.on("click", "#" + this.id + " .view-published-version", this.viewPublishedVersion.bind(this))
				.on("click", "#" + this.id + " .view-draft-version", this.viewUnpublishedVersion.bind(this))
				.on("click", "#" + this.id + " .remove-workflow-link", this.removeWorkflowFromPage.bind(this));
		},
		
		loadMenu: function (data) {
			if (this.debug) console.log(data);
			this.pageUrl = data.pageUrl;
			this.trigger
				.spinStop()
				.text(data.status)
				.addClass("page-info-status")
				.addClass(data.classes)
				.attr("title", data.tooltip);

			if (data.menuItems.length) {
				this.trigger.addClass("aui-button");
				var $menu = $("<aui-dropdown-menu>").attr("id", this.id);
				$.each(data.menuItems, function () {
					var $item = $("<aui-item-link>").text(this.content).addClass(this.class);
					$menu.append($item);
				});
				$("body").append($menu);

				this.trigger
					.attr("aria-controls", this.id)
					.addClass("page-info-status-trigger aui-button aui-dropdown2-trigger");
			}
			else {
				this.trigger.addClass("no-menu").click(function () { return false; });
			}
			
		},
		
		openApplyWorkflowDialog: function () {
			// Get the dialog from the DOM; if there isn't one, create one; show it
		
			var dialog = this.trigger.data("dialog") || new ContentFlowApplyDialog(this.trigger);
			dialog.show();

			this.deactivateTrigger();
		},
		
		openApproveWorkflowDialog: function () {
			// Get the dialog from the DOM; if there isn't one, create one; show it
			var dialog = this.trigger.data("dialog") || new ContentFlowApproveDialog(this.trigger);
			dialog.show();

			this.deactivateTrigger();
		},
		
		openUnlicensedDialog: function () {
			ContentFlow.Dialog2.alert(ContentFlow.getText("com.brikit.contentflow.please.consider.purchasing"), 
				{title: ContentFlow.getText("com.brikit.contentflow.is.not.licensed")});
		},
		
		removeWorkflowFromPage: function () {
			ContentFlow.Dialog2.confirm(ContentFlow.getText("com.brikit.contentflow.remove.workflow.from.page.confirmation"), 
								{title: ContentFlow.getText("com.brikit.contentflow.remove.workflow.title")}, function (dialog) {
                jQuery.ajax({
                    url: ContentFlow.contextPath + "/plugins/contentflow/remove.action",
					data: {
						pageId: ContentFlow.pageId
					},
                    success: function(response) {
                        dialog.hide();
						ContentFlow.reloadBrowser();	
                    },
                    error: function (xhRequest, textStatus, errorThrown) {
                        ContentFlow.alertError("An error occurred while removing the workflow.", errorThrown);
                    },
                });
			});

            return false;
        },
		
		viewPublishedVersion: function () {
			this.viewVersion(true);
		},
		
		viewUnpublishedVersion: function () {
			this.viewVersion(false);
		},
		
		viewVersion: function (published) {
			var url = this.pageUrl;
			if (published) url = ContentFlow.addUrlParameter(url, "published", "true");
			window.location.href = url;
		}
	
	});

	ContentFlow.toInit(function ($) {
		if (ContentFlow.pageId) $("#content-flow-page-status-banner, .workflow-status-macro").each(function () { new ContentFlowPageStatusBanner(this); });
	});

})(jQuery);
