/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.brikit.comalaworkflowsservice.Comala;
import com.brikit.comalaworkflowsservice.ComalaAccessor;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.core.confluence.Confluence;
import java.util.StringTokenizer;

public class ComalaCompatibilityPagePathConverter
implements PathConverter {
    protected static final String CONTENT_FLOW_VIEW_PAGE_PATH = "/contentflow/pages/viewpage.action";
    protected ActiveObjects activeObjects;
    protected ComalaAccessor comalaAccessor;

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public Comala getComala() {
        return this.getComalaAccessor() == null ? null : this.getComalaAccessor().getComala();
    }

    public ComalaAccessor getComalaAccessor() {
        return this.comalaAccessor;
    }

    public ConvertedPath getPath(String path, String queryString) {
        DisplayPath displayPath = new DisplayPath(path);
        ConvertedPath convertedPath = new ConvertedPath(CONTENT_FLOW_VIEW_PAGE_PATH);
        convertedPath.addParameter("spaceKey", displayPath.getSpaceKey());
        convertedPath.addParameter("title", displayPath.getPageTitle());
        return convertedPath;
    }

    public boolean handles(String path, String queryString) {
        if (!this.isComalaInstalled()) {
            return false;
        }
        if (new StringTokenizer(path, "/").countTokens() != 2) {
            return false;
        }
        DisplayPath displayPath = new DisplayPath(path);
        return displayPath.pageFound() && ContentFlowConfiguration.canUseWorkflows(this.getActiveObjects(), displayPath.getSpaceKey());
    }

    public boolean isComalaInstalled() {
        return this.getComala() != null;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void setComalaAccessor(ComalaAccessor comalaAccessor) {
        this.comalaAccessor = comalaAccessor;
    }

    protected class DisplayPath {
        protected String spaceKey;
        protected String pageTitle;

        public DisplayPath(String path) {
            StringTokenizer st = new StringTokenizer(path, "/");
            this.setSpaceKey(st.nextToken());
            this.setPageTitle(st.nextToken());
        }

        public Page getPage() {
            return Confluence.getPage(this.getSpaceKey(), this.getPageTitle());
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public boolean pageFound() {
            return this.getPage() != null;
        }

        public void setPageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }
    }
}

