/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.ScheduledPageStatus;
import com.brikit.contentflow.model.ao.ScheduledPageAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.util.BrikitList;
import java.util.Date;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;

public class ScheduledPageQuery
extends AbstractQuery {
    public ScheduledPageQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    public ScheduledPageAO getScheduledPageForPage(long pageId) {
        Query query = Query.select().where("PAGE_ID = ?", new Object[]{pageId});
        return new BrikitList<ScheduledPageAO>(this.runQuery(query)).first();
    }

    public ScheduledPageAO[] getScheduledPages(String spaceKey) {
        Query query = Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey});
        return this.runQuery(query);
    }

    public Query queryForScheduledPagesToHide() {
        Date now = this.getNow();
        return Query.select().where("ARCHIVE_TIME is not null AND ARCHIVE_TIME < ? AND STATUS = ?", new Object[]{now, ScheduledPageStatus.RELEASED});
    }

    public Query queryForScheduledPagesToRelease() {
        Date now = this.getNow();
        return Query.select().where("PUBLISH_TIME < ? AND (ARCHIVE_TIME is null OR ARCHIVE_TIME > ?) AND STATUS = ?", new Object[]{now, now, ScheduledPageStatus.SCHEDULED});
    }

    public ScheduledPageAO[] runQuery(Query query) {
        return query == null ? new ScheduledPageAO[]{} : (ScheduledPageAO[])this.getActiveObjects().find(ScheduledPageAO.class, query);
    }

    public void streamQuery(Query query, EntityStreamCallback callback) {
        this.getActiveObjects().stream(ScheduledPageAO.class, query, callback);
    }
}

