/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.contentflow.model.ao.ApprovalStepAO;
import com.brikit.contentflow.model.ao.PageReviewFeedbackAO;
import com.brikit.contentflow.model.ao.ReviewerAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.util.BrikitList;
import net.java.ao.Query;

public class PageReviewFeedbackQuery
extends AbstractQuery {
    public PageReviewFeedbackQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    public int countPageReviewFeedback(ApprovalStepAO approvalStepAO) {
        return this.countQuery(this.queryByApprovalStep(approvalStepAO));
    }

    protected int countQuery(Query query) {
        return query == null ? 0 : this.getActiveObjects().count(PageReviewFeedbackAO.class, query);
    }

    public PageReviewFeedbackAO[] getPageReviewFeedback(ApprovalStepAO approvalStepAO) {
        return this.runQuery(this.queryByApprovalStep(approvalStepAO));
    }

    public PageReviewFeedbackAO getPageReviewFeedbackForPage(long pageId) {
        Query query = Query.select().where("PAGE_ID = ?", new Object[]{pageId});
        return new BrikitList<PageReviewFeedbackAO>(this.runQuery(query)).first();
    }

    public PageReviewFeedbackAO[] getPageReviewFeedbackForPageAndReviewer(AbstractPage abstractPage, PageWorkflow pageWorkflow, ReviewerAO reviewerAO) {
        Query query = Query.select().alias(PageReviewFeedbackAO.class, "feedback").alias(ApprovalStepAO.class, "step").alias(ReviewerAO.class, "reviewer").join(ApprovalStepAO.class, "step.ID = feedback.APPROVAL_STEP_AOID").join(ReviewerAO.class, "reviewer.ID = feedback.REVIEWER_AOID").where("PAGE_ID = ? AND PAGE_WORKFLOW_AOID = ? AND REVIEWER_AOID = ?", new Object[]{abstractPage == null ? null : Long.valueOf(abstractPage.getId()), pageWorkflow == null ? null : Integer.valueOf(pageWorkflow.getID()), reviewerAO == null ? null : Integer.valueOf(reviewerAO.getID())});
        return this.runQuery(query);
    }

    public PageReviewFeedbackAO[] getPageReviewFeedbackReferencingApprovalStep(ApprovalStep approvalStep) {
        Query query = Query.select().where("APPROVAL_STEP_AOID = ?", new Object[]{approvalStep.getID()});
        return this.runQuery(query);
    }

    public PageReviewFeedbackAO[] getPageReviewFeedbackReferencingReviewer(Reviewer reviewer) {
        Query query = Query.select().where("REVIEWER_AOID = ?", new Object[]{reviewer.getID()});
        return this.runQuery(query);
    }

    public PageReviewFeedbackAO getPageReviewFeedbackWithId(int id) {
        return (PageReviewFeedbackAO)this.getActiveObjects().get(PageReviewFeedbackAO.class, (Object)id);
    }

    protected Query queryByApprovalStep(ApprovalStepAO approvalStepAO) {
        return Query.select().where("APPROVAL_STEP = ?", new Object[]{approvalStepAO});
    }

    protected PageReviewFeedbackAO[] runQuery(Query query) {
        return query == null ? new PageReviewFeedbackAO[]{} : (PageReviewFeedbackAO[])this.getActiveObjects().find(PageReviewFeedbackAO.class, query);
    }
}

