/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.ScheduledPage;
import com.brikit.contentflow.model.ao.ScheduledPageAO;
import com.brikit.contentflow.model.query.ScheduledPageQuery;
import com.brikit.core.log.BrikitLog;
import net.java.ao.EntityStreamCallback;

public class Scheduler {
    public static void hideScheduledPages(final ActiveObjects activeObjects) {
        ScheduledPageQuery query = new ScheduledPageQuery(activeObjects);
        BrikitLog.log("Hiding scheduled pages...");
        final int[] count = new int[]{0};
        query.streamQuery(query.queryForScheduledPagesToHide(), (EntityStreamCallback)new EntityStreamCallback<ScheduledPageAO, Integer>(){

            public void onRowRead(ScheduledPageAO readOnlyAO) {
                ScheduledPageAO scheduledPageAO = (ScheduledPageAO)activeObjects.get(ScheduledPageAO.class, (Object)readOnlyAO.getID());
                ScheduledPage scheduledPage = new ScheduledPage(activeObjects, scheduledPageAO);
                BrikitLog.log("Hiding: " + scheduledPage.getAbstractPage());
                scheduledPage.hide();
                count[0] = count[0] + 1;
            }
        });
        BrikitLog.log("Hid (restricted) " + count[0] + " scheduled pages.");
    }

    public static void showScheduledPages(final ActiveObjects activeObjects) {
        BrikitLog.log("Releasing scheduled pages...");
        final int[] count = new int[]{0};
        ScheduledPageQuery query = new ScheduledPageQuery(activeObjects);
        query.streamQuery(query.queryForScheduledPagesToRelease(), (EntityStreamCallback)new EntityStreamCallback<ScheduledPageAO, Integer>(){

            public void onRowRead(ScheduledPageAO readOnlyAO) {
                ScheduledPageAO scheduledPageAO = (ScheduledPageAO)activeObjects.get(ScheduledPageAO.class, (Object)readOnlyAO.getID());
                ScheduledPage scheduledPage = new ScheduledPage(activeObjects, scheduledPageAO);
                BrikitLog.log("Releasing: " + scheduledPage.getAbstractPage());
                scheduledPage.release();
                count[0] = count[0] + 1;
            }
        });
        BrikitLog.log("Released " + count[0] + " scheduled pages.");
    }
}

