/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.PageRestricter;
import com.brikit.contentflow.model.ScheduledPageStatus;
import com.brikit.contentflow.model.ao.ScheduledPageAO;
import com.brikit.contentflow.model.query.ScheduledPageQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class ScheduledPage
extends AbstractActiveObjectsModel
implements Comparable {
    protected ScheduledPageAO activeObject;

    public ScheduledPage(ActiveObjects activeObjects, ScheduledPageAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    protected static ScheduledPage create(ActiveObjects activeObjects, String pageIdAsString) {
        return ScheduledPage.create(activeObjects, Confluence.getPageOrBlogPost(pageIdAsString));
    }

    protected static ScheduledPage create(ActiveObjects activeObjects, AbstractPage abstractPage) {
        ScheduledPageAO scheduledPageAO = (ScheduledPageAO)activeObjects.create(ScheduledPageAO.class, new DBParam[0]);
        scheduledPageAO.setPageId(abstractPage.getId());
        scheduledPageAO.setSpaceKey(Confluence.getSpaceKey(abstractPage));
        ScheduledPage scheduledPage = new ScheduledPage(activeObjects, scheduledPageAO);
        scheduledPage.save();
        return scheduledPage;
    }

    protected static List<ScheduledPage> fromActiveObjects(ActiveObjects activeObjects, ScheduledPageAO[] scheduledPageAOs) {
        ArrayList<ScheduledPage> scheduledPages = new ArrayList<ScheduledPage>(scheduledPageAOs.length);
        for (ScheduledPageAO pageInReviewAO : scheduledPageAOs) {
            scheduledPages.add(new ScheduledPage(activeObjects, pageInReviewAO));
        }
        return scheduledPages;
    }

    protected static ScheduledPageAO getScheduledPageAO(ActiveObjects activeObjects, long pageId) {
        ScheduledPageQuery query = new ScheduledPageQuery(activeObjects);
        return query.getScheduledPageForPage(pageId);
    }

    public static ScheduledPage getScheduledPageForPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return ScheduledPage.getScheduledPageForPage(activeObjects, abstractPage.getId());
    }

    public static ScheduledPage getScheduledPageForPage(ActiveObjects activeObjects, long pageId) {
        ScheduledPageAO scheduledPageAO = ScheduledPage.getScheduledPageAO(activeObjects, pageId);
        return scheduledPageAO == null ? null : new ScheduledPage(activeObjects, scheduledPageAO);
    }

    public static List<ScheduledPage> getScheduledPages(ActiveObjects activeObjects, String spaceKey) {
        ScheduledPageQuery query = new ScheduledPageQuery(activeObjects);
        return ScheduledPage.fromActiveObjects(activeObjects, query.getScheduledPages(spaceKey));
    }

    public static boolean isScheduled(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return ScheduledPage.getScheduledPageForPage(activeObjects, abstractPage) != null;
    }

    public static void schedulePage(ActiveObjects activeObjects, AbstractPage abstractPage, Date releaseDateTime, Date hideDateTime) {
        ScheduledPage scheduledPage = ScheduledPage.getScheduledPageForPage(activeObjects, abstractPage);
        if (scheduledPage == null) {
            scheduledPage = ScheduledPage.create(activeObjects, abstractPage);
        }
        scheduledPage.schedule(releaseDateTime, hideDateTime);
    }

    public static void unschedule(ActiveObjects activeObjects, AbstractPage abstractPage) {
        ScheduledPage scheduledPage = ScheduledPage.getScheduledPageForPage(activeObjects, abstractPage);
        if (scheduledPage == null) {
            return;
        }
        scheduledPage.removeViewRestrictions();
        scheduledPage.delete();
    }

    public void applyViewRestrictions() {
        PageRestricter pageRestricter = new PageRestricter(this.getActiveObjects(), this.getAbstractPage());
        pageRestricter.restrictForScheduling();
    }

    public int compareTo(Object o) {
        String title1 = this.getAbstractPage().getTitle();
        String title2 = ((ScheduledPage)o).getAbstractPage().getTitle();
        return Collator.getInstance().compare(title1 == null ? "" : title1, title2 == null ? "" : title2);
    }

    protected void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public ScheduledPageAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getHideTime() {
        Date date = this.getActiveObject().getArchiveTime();
        return date == null ? null : BrikitDate.toCalendar(date);
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public Calendar getReleaseTime() {
        Date date = this.getActiveObject().getPublishTime();
        return date == null ? null : BrikitDate.toCalendar(date);
    }

    public Space getSpace() {
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public String getSpaceName() {
        return Confluence.getSpaceName(this.getSpaceKey());
    }

    public String getStatus() {
        return this.getActiveObject().getStatus();
    }

    public boolean hasHideTime() {
        return this.getHideTime() != null;
    }

    public boolean hasReleaseTime() {
        return this.getReleaseTime() != null;
    }

    public void hide() {
        this.applyViewRestrictions();
        this.setStatus(ScheduledPageStatus.HIDDEN.toString());
        this.save();
    }

    public boolean isAfterReleaseTime() {
        return this.isAfterReleaseTime(Confluence.getSystemTimeNow());
    }

    public boolean isAfterReleaseTime(Calendar date) {
        return !this.hasReleaseTime() || BrikitDate.isAfter(date, this.getReleaseTime());
    }

    public boolean isBeforeHideTime() {
        return this.isBeforeHideTime(Confluence.getSystemTimeNow());
    }

    public boolean isBeforeHideTime(Calendar date) {
        return !this.hasHideTime() || BrikitDate.isBefore(date, this.getHideTime());
    }

    public boolean isBeforeReleaseTime() {
        return this.isBeforeReleaseTime(Confluence.getSystemTimeNow());
    }

    public boolean isBeforeReleaseTime(Calendar date) {
        return this.hasReleaseTime() && BrikitDate.isBefore(date, this.getReleaseTime());
    }

    public boolean isInScheduledWindow() {
        return this.isInScheduledWindow(Confluence.getUserTimeNow());
    }

    public boolean isInScheduledWindow(Calendar date) {
        return this.isAfterReleaseTime(date) && this.isBeforeHideTime(date);
    }

    public void release() {
        this.removeViewRestrictions();
        this.setStatus(ScheduledPageStatus.RELEASED.toString());
        this.save();
    }

    protected void removeViewRestrictions() {
        PageRestricter pageRestricter = new PageRestricter(this.getActiveObjects(), this.getAbstractPage());
        pageRestricter.unrestrictForScheduling();
    }

    public void save() {
        this.getActiveObject().save();
    }

    protected void schedule(Date releaseDateTime, Date hideDateTime) {
        this.setReleaseTime(releaseDateTime);
        this.setHideTime(hideDateTime);
        this.setStatus(ScheduledPageStatus.SCHEDULED.toString());
        this.save();
        if (this.isInScheduledWindow()) {
            this.release();
        } else if (this.isBeforeReleaseTime()) {
            this.applyViewRestrictions();
        } else {
            this.hide();
        }
    }

    public void setActiveObject(ScheduledPageAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setHideTime(Calendar hideTime) {
        this.setHideTime(BrikitDate.toDate(hideTime));
    }

    public void setHideTime(Date hideTime) {
        this.getActiveObject().setArchiveTime(hideTime);
    }

    public void setReleaseTime(Calendar setReleaseTime) {
        this.setReleaseTime(BrikitDate.toDate(setReleaseTime));
    }

    public void setReleaseTime(Date setReleaseTime) {
        this.getActiveObject().setPublishTime(setReleaseTime);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }

    public void setStatus(String status) {
        this.getActiveObject().setStatus(status);
    }
}

