/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.PageStatusContentEntity;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.model.ao.PageStatusAO;
import com.brikit.contentflow.model.query.PageStatusQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.util.BrikitList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PageStatus
extends AbstractActiveObjectsModel
implements Comparable {
    protected PageStatusAO activeObject;
    protected List<ApprovalStep> approvalSteps;
    protected List<Workflow> workflows;

    protected PageStatus(ActiveObjects activeObjects, PageStatusAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static boolean allowManualPageStatusChanges(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage != null && !PageWorkflow.hasActiveWorkflow(activeObjects, abstractPage);
    }

    public static PageStatus create(ActiveObjects activeObjects, String name, String label) {
        PageStatusAO pageStatusAO = (PageStatusAO)activeObjects.create(PageStatusAO.class, new DBParam[0]);
        pageStatusAO.setName(name);
        pageStatusAO.setLabel(label);
        PageStatus pageStatus = new PageStatus(activeObjects, pageStatusAO);
        pageStatus.save();
        return pageStatus;
    }

    protected static BrikitList<PageStatus> fromActiveObjects(ActiveObjects activeObjects, PageStatusAO[] pageStatusAOs) {
        BrikitList<PageStatus> statuses = new BrikitList<PageStatus>(pageStatusAOs.length);
        for (PageStatusAO pageStatusAO : pageStatusAOs) {
            statuses.add(new PageStatus(activeObjects, pageStatusAO));
        }
        return statuses;
    }

    public static BrikitList<PageStatus> getAll(ActiveObjects activeObjects) {
        PageStatusQuery query = new PageStatusQuery(activeObjects);
        PageStatusAO[] pageStatusAOs = query.getAll();
        if (pageStatusAOs.length == 0) {
            PageStatus.create(activeObjects, "Draft", "draft");
            PageStatus.create(activeObjects, "Published", "published");
            PageStatus.create(activeObjects, "Deprecated", "deprecated");
            pageStatusAOs = query.getAll();
        }
        return PageStatus.fromActiveObjects(activeObjects, pageStatusAOs);
    }

    public static PageStatus getPageStatus(ActiveObjects activeObjects, Long id) {
        PageStatusAO pageStatusAO = id == null ? null : PageStatus.getPageStatusAO(activeObjects, id);
        return pageStatusAO == null ? null : new PageStatus(activeObjects, pageStatusAO);
    }

    public static PageStatusAO getPageStatusAO(ActiveObjects activeObjects, Long id) {
        PageStatusQuery query = new PageStatusQuery(activeObjects);
        return query.getPageStatus(id);
    }

    public static PageStatus getPageStatusForPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PageStatusContentEntity pageStatusContentEntity = PageStatusContentEntity.getPageStatusContentEntity(activeObjects, abstractPage);
        return pageStatusContentEntity == null ? null : pageStatusContentEntity.getPageStatus();
    }

    public static PageStatus getPageStatusForPage(ActiveObjects activeObjects, long pageId) {
        PageStatusContentEntity pageStatusContentEntity = PageStatusContentEntity.getPageStatusContentEntity(activeObjects, pageId);
        return pageStatusContentEntity == null ? null : pageStatusContentEntity.getPageStatus();
    }

    public int compareTo(Object o) {
        if (!(o instanceof PageStatus)) {
            return -1;
        }
        return this.getName().compareTo(((PageStatus)o).getName());
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public PageStatusAO getActiveObject() {
        return this.activeObject;
    }

    public List<ApprovalStep> getApprovalSteps() {
        if (this.approvalSteps == null) {
            this.approvalSteps = ApprovalStep.fromActiveObjects(this.getActiveObjects(), this.getActiveObject().getApprovalStepAOs());
        }
        return this.approvalSteps;
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public String getLabel() {
        return this.getActiveObject().getLabel();
    }

    public String getName() {
        return this.getActiveObject().getName();
    }

    public boolean isInUse() {
        return PageStatusContentEntity.isInUse(this.getActiveObjects(), this);
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PageStatusAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setLabel(String label) {
        this.getActiveObject().setLabel(label);
    }

    public void setName(String name) {
        this.getActiveObject().setName(name);
    }
}

