/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.brikit.contentflow.model.ApprovalStatus;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.PageReviewer;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.contentflow.model.ao.PageReviewFeedbackAO;
import com.brikit.contentflow.model.query.PageReviewFeedbackQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PageReviewFeedback
extends AbstractActiveObjectsModel {
    public static Comparator<PageReviewFeedback> DateOrder = new Comparator<PageReviewFeedback>(){

        @Override
        public int compare(PageReviewFeedback pageReviewFeedback1, PageReviewFeedback pageReviewFeedback2) {
            return pageReviewFeedback1.getCreationDate().compareTo(pageReviewFeedback2.getCreationDate());
        }
    };
    protected PageReviewFeedbackAO activeObject;
    protected PageWorkflow pageWorkflow;
    protected ApprovalStep approvalStep;
    protected Reviewer reviewer;

    protected PageReviewFeedback(ActiveObjects activeObjects, PageReviewFeedbackAO activeObject) {
        this(activeObjects, activeObject, null);
    }

    protected PageReviewFeedback(ActiveObjects activeObjects, PageReviewFeedbackAO activeObject, ApprovalStep approvalStep) {
        super(activeObjects);
        this.setActiveObject(activeObject);
        this.approvalStep = approvalStep;
    }

    public static PageReviewFeedback create(ActiveObjects activeObjects, AbstractPage abstractPage, PageReviewer pageReviewer, String comment, ApprovalStatus approvalStatus) {
        ApprovalStep approvalStep = pageReviewer.getApprovalStep();
        PageReviewFeedbackAO pageReviewFeedbackAO = (PageReviewFeedbackAO)activeObjects.create(PageReviewFeedbackAO.class, new DBParam[0]);
        pageReviewFeedbackAO.setPageWorkflowAO(pageReviewer.getPageApprovalStep().getPageWorkflow().getActiveObject());
        pageReviewFeedbackAO.setPageId(abstractPage.getId());
        pageReviewFeedbackAO.setApprovalStepAO(approvalStep.getActiveObject());
        pageReviewFeedbackAO.setReviewerAO(pageReviewer.getReviewer().getActiveObject());
        pageReviewFeedbackAO.setComment(comment);
        if (approvalStatus != null) {
            pageReviewFeedbackAO.setApprovalStatus(approvalStatus.name());
        }
        pageReviewFeedbackAO.setCreationDate(new Date());
        pageReviewFeedbackAO.setUserKey(Confluence.getUserKeyString());
        PageReviewFeedback pageReviewFeedback = new PageReviewFeedback(activeObjects, pageReviewFeedbackAO, approvalStep);
        pageReviewFeedback.save();
        return pageReviewFeedback;
    }

    protected static List<PageReviewFeedback> fromActiveObjects(ActiveObjects activeObjects, PageReviewFeedbackAO[] pageReviewFeedbackAOs) {
        ArrayList<PageReviewFeedback> pageReviewFeedback = new ArrayList<PageReviewFeedback>(pageReviewFeedbackAOs.length);
        for (PageReviewFeedbackAO pageReviewFeedbackAO : pageReviewFeedbackAOs) {
            pageReviewFeedback.add(new PageReviewFeedback(activeObjects, pageReviewFeedbackAO));
        }
        return pageReviewFeedback;
    }

    public static List<PageReviewFeedback> getPageReviewFeedbackReferencingApprovalStep(ActiveObjects activeObjects, ApprovalStep approvalStep) {
        PageReviewFeedbackQuery query = new PageReviewFeedbackQuery(activeObjects);
        return PageReviewFeedback.fromActiveObjects(activeObjects, query.getPageReviewFeedbackReferencingApprovalStep(approvalStep));
    }

    public static List<PageReviewFeedback> getPageReviewFeedbackReferencingReviewer(ActiveObjects activeObjects, Reviewer reviewer) {
        PageReviewFeedbackQuery query = new PageReviewFeedbackQuery(activeObjects);
        return PageReviewFeedback.fromActiveObjects(activeObjects, query.getPageReviewFeedbackReferencingReviewer(reviewer));
    }

    public void clearApprovalStepReference() {
        this.getActiveObject().setApprovalStepAO(null);
        this.save();
    }

    public void clearReviewerReference() {
        this.getActiveObject().setReviewerAO(null);
        this.save();
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public PageReviewFeedbackAO getActiveObject() {
        return this.activeObject;
    }

    public ApprovalStatus getApprovalStatus() {
        return BrikitString.isSet(this.getApprovalStatusString()) ? ApprovalStatus.valueOf(this.getApprovalStatusString()) : null;
    }

    public String getApprovalStatusString() {
        return this.getActiveObject().getApprovalStatus();
    }

    public ApprovalStep getApprovalStep() {
        if (this.approvalStep == null) {
            this.approvalStep = new ApprovalStep(this.getActiveObjects(), this.getActiveObject().getApprovalStepAO());
        }
        return this.approvalStep;
    }

    public String getComment() {
        return this.getActiveObject().getComment();
    }

    public Calendar getCreationDate() {
        return BrikitDate.toCalendar(this.getActiveObject().getCreationDate());
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public PageWorkflow getPageWorkflow() {
        if (this.pageWorkflow == null) {
            this.pageWorkflow = new PageWorkflow(this.getActiveObjects(), this.getActiveObject().getPageWorkflowAO());
        }
        return this.pageWorkflow;
    }

    public Reviewer getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new Reviewer(this.getActiveObjects(), this.getActiveObject().getReviewerAO());
        }
        return this.reviewer;
    }

    public ConfluenceUser getUser() {
        ConfluenceUser user = Confluence.getConfluenceUser(this.getUserKey());
        if (user == null) {
            user = Confluence.getConfluenceUser(this.getUserKeyString());
        }
        return user;
    }

    protected UserKey getUserKey() {
        return BrikitString.isSet(this.getUserKeyString()) ? Confluence.getUserKey(this.getUserKeyString()) : null;
    }

    protected String getUserKeyString() {
        return this.getActiveObject().getUserKey();
    }

    public String getUsername() {
        ConfluenceUser user = this.getUser();
        return user == null ? null : user.getName();
    }

    public boolean isApproved() {
        return this.getApprovalStatus() == ApprovalStatus.APPROVED;
    }

    public boolean isRejected() {
        return this.getApprovalStatus() == ApprovalStatus.REJECTED;
    }

    public boolean isReset() {
        return this.getApprovalStatus() == ApprovalStatus.RESET;
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PageReviewFeedbackAO activeObject) {
        this.activeObject = activeObject;
    }

    protected void setApprovalStatus(ApprovalStatus approvalStatus) {
        this.setApprovalStatusString(approvalStatus == null ? null : approvalStatus.name());
    }

    protected void setApprovalStatusString(String approvalStatusString) {
        this.getActiveObject().setApprovalStatus(approvalStatusString);
    }

    public void setComment(String comment) {
        this.getActiveObject().setComment(comment);
    }

    public void setCreationDate(Calendar creationDate) {
        this.setCreationDate(BrikitDate.toDate(creationDate));
    }

    public void setCreationDate(Date creationDate) {
        this.getActiveObject().setCreationDate(creationDate);
    }
}

