/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.ArchivePolicy;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.ao.PageInReviewAO;
import com.brikit.contentflow.model.query.PageInReviewQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitString;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PageInReview
extends AbstractActiveObjectsModel
implements Comparable {
    protected PageInReviewAO activeObject;

    public PageInReview(ActiveObjects activeObjects, PageInReviewAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static void addReviewLabel(ActiveObjects activeObjects, AbstractPage abstractPage) {
        ContentFlowConfiguration contentFlowConfiguration = ContentFlowConfiguration.forPage(activeObjects, abstractPage);
        ArchivePolicy archivePolicy = contentFlowConfiguration.getArchivePolicy();
        PageInReview.addReviewLabel(activeObjects, abstractPage, archivePolicy);
    }

    public static void addReviewLabel(ActiveObjects activeObjects, AbstractPage abstractPage, ArchivePolicy archivePolicy) {
        if (archivePolicy == null) {
            return;
        }
        String reviewLabel = archivePolicy.getReviewLabel();
        if (BrikitString.isSet(reviewLabel) && !Confluence.hasLabel((AbstractLabelableEntityObject)abstractPage, reviewLabel)) {
            Confluence.addLabel(reviewLabel, abstractPage);
        }
    }

    public static PageInReview create(ActiveObjects activeObjects, long pageId, ArchivePolicy archivePolicy) {
        return PageInReview.create(activeObjects, Confluence.getPageOrBlogPost(pageId), archivePolicy);
    }

    public static PageInReview create(ActiveObjects activeObjects, String pageIdAsString, ArchivePolicy archivePolicy) {
        return PageInReview.create(activeObjects, Confluence.getPageOrBlogPost(pageIdAsString), archivePolicy);
    }

    public static PageInReview create(ActiveObjects activeObjects, AbstractPage abstractPage, ArchivePolicy archivePolicy) {
        PageInReviewAO pageInReviewAO = (PageInReviewAO)activeObjects.create(PageInReviewAO.class, new DBParam[0]);
        pageInReviewAO.setPageId(abstractPage.getId());
        pageInReviewAO.setSpaceKey(Confluence.getSpaceKey(abstractPage));
        PageInReview pageInReview = new PageInReview(activeObjects, pageInReviewAO);
        pageInReview.setDateFlagged(BrikitDate.getToday());
        pageInReview.save();
        PageInReview.addReviewLabel(activeObjects, abstractPage, archivePolicy);
        return pageInReview;
    }

    protected static List<PageInReview> fromActiveObjects(ActiveObjects activeObjects, PageInReviewAO[] pageInReviewAOs) {
        ArrayList<PageInReview> pagesInReview = new ArrayList<PageInReview>(pageInReviewAOs.length);
        for (PageInReviewAO pageInReviewAO : pageInReviewAOs) {
            if (pageInReviewAO == null) continue;
            pagesInReview.add(new PageInReview(activeObjects, pageInReviewAO));
        }
        return pagesInReview;
    }

    protected static PageInReviewAO getPageInReviewAO(ActiveObjects activeObjects, long pageId) {
        PageInReviewQuery query = new PageInReviewQuery(activeObjects);
        return query.getPageInReviewForPage(pageId);
    }

    public static PageInReview getPageInReviewForPage(ActiveObjects activeObjects, long pageId) {
        PageInReviewAO pageInReviewAO = PageInReview.getPageInReviewAO(activeObjects, pageId);
        return pageInReviewAO == null ? null : new PageInReview(activeObjects, pageInReviewAO);
    }

    public static PageInReview getPageInReviewForPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage == null ? null : PageInReview.getPageInReviewForPage(activeObjects, abstractPage.getId());
    }

    public static List<PageInReview> getPageInReviews(ActiveObjects activeObjects, String spaceKey) {
        PageInReviewQuery query = new PageInReviewQuery(activeObjects);
        return PageInReview.fromActiveObjects(activeObjects, query.getPageInReviews(spaceKey));
    }

    public static void markAsReviewed(ActiveObjects activeObjects, AbstractPage abstractPage) throws Exception {
        Confluence.savePage(abstractPage, abstractPage.getBodyAsString(), Confluence.getText("com.brikit.contentflow.page.marked.as.reviewed"), false);
    }

    public static void removeReviewLabel(ActiveObjects activeObjects, AbstractPage abstractPage) {
        ContentFlowConfiguration contentFlowConfiguration = ContentFlowConfiguration.forPage(activeObjects, abstractPage);
        ArchivePolicy archivePolicy = contentFlowConfiguration.getArchivePolicy();
        if (archivePolicy == null) {
            return;
        }
        String reviewLabel = archivePolicy.getReviewLabel();
        if (BrikitString.isSet(reviewLabel)) {
            Confluence.removeLabel(reviewLabel, abstractPage);
        }
    }

    public static void removed(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        PageInReview pageInReview = PageInReview.getPageInReviewForPage(activeObjects, abstractPage);
        if (pageInReview != null) {
            pageInReview.delete();
        }
    }

    public static void updated(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        PageInReview pageInReview = PageInReview.getPageInReviewForPage(activeObjects, abstractPage);
        if (pageInReview == null) {
            return;
        }
        pageInReview.delete();
        PageInReview.removeReviewLabel(activeObjects, abstractPage);
    }

    public int compareTo(Object o) {
        String title1 = this.getAbstractPage().getTitle();
        String title2 = ((PageInReview)o).getAbstractPage().getTitle();
        return Collator.getInstance().compare(title1 == null ? "" : title1, title2 == null ? "" : title2);
    }

    public static boolean pageNeedsReview(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return PageInReview.getPageInReviewForPage(activeObjects, abstractPage) != null;
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public PageInReviewAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getDateFlagged() {
        Date date = this.getActiveObject().getDateFlagged();
        return date == null ? null : BrikitDate.toCalendar(date);
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public Calendar getReviewByDate() {
        ArchivePolicy archivePolicy = ArchivePolicy.forPage(this.getActiveObjects(), this.getAbstractPage());
        return archivePolicy != null && archivePolicy.shouldArchive() ? BrikitDate.addDays(this.getDateFlagged(), archivePolicy.getArchiveAfterDaysInReview()) : null;
    }

    public Space getSpace() {
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public String getSpaceName() {
        return Confluence.getSpaceName(this.getSpaceKey());
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PageInReviewAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setDateFlagged(Calendar dateFlagged) {
        this.setDateFlagged(BrikitDate.toDate(dateFlagged));
    }

    public void setDateFlagged(Date dateFlagged) {
        this.getActiveObject().setDateFlagged(dateFlagged);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }
}

