/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.ArchivePolicy;
import com.brikit.contentflow.model.LastPageView;
import com.brikit.contentflow.model.PageInReview;
import com.brikit.contentflow.model.SpaceActivity;
import com.brikit.contentflow.model.ao.PageActivityAO;
import com.brikit.contentflow.model.query.PageActivityQuery;
import com.brikit.contentflow.settings.PageActivitySettings;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PageActivity
extends AbstractActiveObjectsModel {
    public static Comparator<PageActivity> DateOrder = new Comparator<PageActivity>(){

        @Override
        public int compare(PageActivity pageActivity1, PageActivity pageActivity2) {
            return pageActivity1.getDate().compareTo(pageActivity2.getDate());
        }
    };
    public static Comparator<PageActivity> PageOrder = new Comparator<PageActivity>(){

        @Override
        public int compare(PageActivity pageActivity1, PageActivity pageActivity2) {
            int result = new Long(pageActivity1.getPageId()).compareTo(new Long(pageActivity2.getPageId()));
            return result == 0 ? pageActivity1.getDate().compareTo(pageActivity2.getDate()) : result;
        }
    };
    protected PageActivityAO activeObject;

    protected PageActivity(ActiveObjects activeObjects, PageActivityAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static PageActivity create(ActiveObjects activeObjects, long pageId, Calendar date) {
        date = BrikitDate.dateOnly(date);
        PageActivityAO pageActivityAO = (PageActivityAO)activeObjects.create(PageActivityAO.class, new DBParam[0]);
        pageActivityAO.setPageId(pageId);
        pageActivityAO.setDate(date.getTime());
        pageActivityAO.setSpaceKey(Confluence.getSpaceKey(pageId));
        PageActivity pageActivity = new PageActivity(activeObjects, pageActivityAO);
        pageActivity.save();
        return pageActivity;
    }

    public static void createBaselineActivityRecord(ActiveObjects activeObjects, long pageId) {
        if (PageActivity.hasPageActivity(activeObjects, pageId)) {
            return;
        }
        PageActivity pageActivity = PageActivity.create(activeObjects, pageId, PageActivity.lastViewed(activeObjects, pageId));
        pageActivity.increaseViewCount(1);
    }

    protected static List<PageActivity> fromActiveObjects(ActiveObjects activeObjects, PageActivityAO[] pageActivityAOs) {
        ArrayList<PageActivity> pageActivities = new ArrayList<PageActivity>(pageActivityAOs.length);
        for (PageActivityAO pageActivityAO : pageActivityAOs) {
            pageActivities.add(new PageActivity(activeObjects, pageActivityAO));
        }
        return pageActivities;
    }

    public static boolean hasPageActivity(ActiveObjects activeObjects, long pageId) {
        return PageActivity.latestPageActivity(activeObjects, pageId) != null;
    }

    public static Calendar lastViewed(ActiveObjects activeObjects, long pageId) {
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        PageActivityAO lastActivity = query.latestPageActivity(pageId);
        Date date = lastActivity != null ? lastActivity.getDate() : Confluence.getLastModificationDate((ContentEntityObject)Confluence.getPageOrBlogPost(pageId));
        return BrikitDate.toCalendar(date);
    }

    public static PageActivity latestPageActivity(ActiveObjects activeObjects, long pageId) {
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        PageActivityAO lastActivityAO = query.latestPageActivity(pageId);
        return lastActivityAO == null ? null : new PageActivity(activeObjects, lastActivityAO);
    }

    public static PageActivity getOrCreatePageActivity(ActiveObjects activeObjects, long pageId, Calendar date) {
        PageActivity pageActivity = PageActivity.getPageActivity(activeObjects, pageId, date = BrikitDate.dateOnly(date));
        if (pageActivity == null) {
            pageActivity = PageActivity.create(activeObjects, pageId, date);
        }
        return pageActivity;
    }

    public static PageActivity getPageActivity(ActiveObjects activeObjects, long pageId, Calendar date) {
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        PageActivityAO pageActivityAO = query.getPageActivity(pageId, date);
        return pageActivityAO == null ? null : new PageActivity(activeObjects, pageActivityAO);
    }

    public static List<PageActivity> getPageActivityHistory(ActiveObjects activeObjects, long pageId, int daysOfHistory) {
        Calendar end = BrikitDate.getToday();
        Calendar start = BrikitDate.addDays(end, -1 * daysOfHistory);
        return PageActivity.getPageActivityHistory(activeObjects, pageId, start, end);
    }

    public static List<PageActivity> getPageActivityHistory(ActiveObjects activeObjects, long pageId, Calendar start, Calendar end) {
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        return PageActivity.fromActiveObjects(activeObjects, query.getPageActivityHistory(pageId, start, end));
    }

    public static BrikitMap<String, Integer> getPageViewCounts(ActiveObjects activeObjects, String spaceKey, int days) {
        Calendar end = BrikitDate.getToday();
        Calendar start = BrikitDate.addDays(end, -1 * days);
        BrikitMap<String, Integer> counts = new BrikitMap<String, Integer>();
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        for (PageActivityAO pageActivityAO : query.getPageActivityHistoryForSpace(spaceKey, start, end)) {
            String pageId = Long.toString(pageActivityAO.getPageId());
            Integer count = (Integer)counts.get(pageId);
            count = (count == null ? 0 : count) + pageActivityAO.getViewCount();
            counts.put(pageId, count);
        }
        return counts;
    }

    public static void increaseViewCount(ActiveObjects activeObjects, long pageId, Calendar date, int views) {
        PageActivity.getOrCreatePageActivity(activeObjects, pageId, date).increaseViewCount(views);
    }

    public static void pageViewed(ActiveObjects activeObjects, long pageId, Calendar date) {
        ArchivePolicy archivePolicy = ArchivePolicy.forPage(activeObjects, pageId);
        if (archivePolicy != null && archivePolicy.usesPageViews() && PageInReview.getPageInReviewForPage(activeObjects, pageId) != null) {
            return;
        }
        PageActivity.increaseViewCount(activeObjects, pageId, date, 1);
    }

    public static int purgeActivity(ActiveObjects activeObjects, Space space) {
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        int days = PageActivitySettings.getHistoryDays(space);
        String spaceKey = space.getKey();
        int count = query.countPageActivityHistoryQuery(spaceKey, days);
        BrikitLog.log("Purging " + count + " page activity records for " + spaceKey + ": " + Confluence.getSpace(spaceKey));
        for (PageActivityAO pageActivityAO : query.getPageActivityOlderThan(spaceKey, days)) {
            activeObjects.delete(new RawEntity[]{pageActivityAO});
        }
        return count;
    }

    public static void removeViewCounts(ActiveObjects activeObjects, long pageId) {
        String spaceKey = Confluence.getSpaceKey(pageId);
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        for (PageActivityAO pageActivityAO : query.getAllPageActivityHistory(pageId)) {
            SpaceActivity.increaseViewCount(activeObjects, spaceKey, BrikitDate.toCalendar(pageActivityAO.getDate()), -1 * pageActivityAO.getViewCount());
            activeObjects.delete(new RawEntity[]{pageActivityAO});
        }
    }

    public static void transferViewCounts(ActiveObjects activeObjects, long pageId, String fromSpaceKey, String toSpaceKey) {
        PageActivityQuery query = new PageActivityQuery(activeObjects);
        for (PageActivityAO pageActivityAO : query.getAllPageActivityHistory(pageId)) {
            SpaceActivity.increaseViewCount(activeObjects, fromSpaceKey, BrikitDate.toCalendar(pageActivityAO.getDate()), -1 * pageActivityAO.getViewCount());
            SpaceActivity.increaseViewCount(activeObjects, toSpaceKey, BrikitDate.toCalendar(pageActivityAO.getDate()), pageActivityAO.getViewCount());
        }
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public PageActivityAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getDate() {
        return BrikitDate.toCalendar(this.getActiveObject().getDate());
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public int getViewCount() {
        return this.getActiveObject().getViewCount();
    }

    public void increaseViewCount(int views) {
        this.getActiveObject().setViewCount(this.getActiveObject().getViewCount() + views);
        this.getActiveObject().save();
        String spaceKey = Confluence.getSpaceKey(this.getPageId());
        SpaceActivity.increaseViewCount(this.getActiveObjects(), spaceKey, this.getDate(), views);
        Calendar pageLastViewed = this.getActiveObject().getViewCount() > 0 ? this.getDate() : PageActivity.lastViewed(this.getActiveObjects(), this.getPageId());
        LastPageView.pageViewed(this.getActiveObjects(), this.getPageId(), pageLastViewed);
    }

    public void incrementViewCount() {
        this.increaseViewCount(1);
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PageActivityAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setDate(Calendar date) {
        this.setDate(date.getTime());
    }

    public void setDate(Date date) {
        this.getActiveObject().setDate(date);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }
}

