/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.contentflow.model.ao.ContentOwnerAO;
import com.brikit.contentflow.model.query.ContentOwnerQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class ContentOwner
extends AbstractActiveObjectsModel {
    protected ContentOwnerAO activeObject;

    protected ContentOwner(ActiveObjects activeObjects, ContentOwnerAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    protected static ContentOwner create(ActiveObjects activeObjects, ConfluenceUser user, String spaceKey, Long pageId) {
        ContentOwnerAO contentOwnerAO = (ContentOwnerAO)activeObjects.create(ContentOwnerAO.class, new DBParam[0]);
        if (BrikitString.isSet(spaceKey)) {
            contentOwnerAO.setSpaceKey(spaceKey);
        } else {
            contentOwnerAO.setPageId(pageId);
        }
        contentOwnerAO.setUserKey(user.getKey().getStringValue());
        ContentOwner contentOwner = new ContentOwner(activeObjects, contentOwnerAO);
        contentOwner.save();
        return contentOwner;
    }

    public static ContentOwner create(ActiveObjects activeObjects, ConfluenceUser user, long pageId) {
        return ContentOwner.create(activeObjects, user, null, pageId);
    }

    public static ContentOwner create(ActiveObjects activeObjects, ConfluenceUser user, String spaceKey) {
        return ContentOwner.create(activeObjects, user, spaceKey, null);
    }

    protected static BrikitList<ContentOwner> fromActiveObjects(ActiveObjects activeObjects, ContentOwnerAO[] contentOwnerAOs) {
        BrikitList<ContentOwner> pageActivities = new BrikitList<ContentOwner>(contentOwnerAOs.length);
        for (ContentOwnerAO contentOwnerAO : contentOwnerAOs) {
            pageActivities.add(new ContentOwner(activeObjects, contentOwnerAO));
        }
        return pageActivities;
    }

    public static ContentOwner getContentOwner(ActiveObjects activeObjects, long pageId) {
        ContentOwnerQuery query = new ContentOwnerQuery(activeObjects);
        ContentOwnerAO contentOwnerAO = query.getContentOwner(pageId);
        return contentOwnerAO == null ? null : new ContentOwner(activeObjects, contentOwnerAO);
    }

    public static ContentOwner getContentOwner(ActiveObjects activeObjects, String spaceKey) {
        ContentOwnerQuery query = new ContentOwnerQuery(activeObjects);
        ContentOwnerAO contentOwnerAO = query.getContentOwner(spaceKey);
        return contentOwnerAO == null ? null : new ContentOwner(activeObjects, contentOwnerAO);
    }

    public static ContentOwner getOrCreateContentOwner(ActiveObjects activeObjects, ConfluenceUser user, long pageId) {
        ContentOwner contentOwner = ContentOwner.getContentOwner(activeObjects, pageId);
        if (contentOwner == null) {
            contentOwner = ContentOwner.create(activeObjects, user, pageId);
        }
        return contentOwner;
    }

    public static ContentOwner getOrCreateContentOwner(ActiveObjects activeObjects, ConfluenceUser user, String spaceKey) {
        ContentOwner contentOwner = ContentOwner.getContentOwner(activeObjects, spaceKey);
        if (contentOwner == null) {
            contentOwner = ContentOwner.create(activeObjects, user, spaceKey);
        }
        return contentOwner;
    }

    public static void setContentOwner(ActiveObjects activeObjects, ConfluenceUser user, long pageId) {
        ContentOwner contentOwner = ContentOwner.getOrCreateContentOwner(activeObjects, user, pageId);
        contentOwner.setOwner(user);
        contentOwner.save();
    }

    public static void setContentOwner(ActiveObjects activeObjects, ConfluenceUser user, String spaceKey) {
        ContentOwner contentOwner = ContentOwner.getOrCreateContentOwner(activeObjects, user, spaceKey);
        contentOwner.setOwner(user);
        contentOwner.save();
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public ContentOwnerAO getActiveObject() {
        return this.activeObject;
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public Space getSpace() {
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public ConfluenceUser getUser() {
        return Confluence.getConfluenceUserByUserKey(this.getUserKey());
    }

    public String getUserKey() {
        return this.getActiveObject().getUserKey();
    }

    public String getUserName() {
        ConfluenceUser user = this.getUser();
        return user == null ? null : user.getName();
    }

    public String getFullName() {
        ConfluenceUser user = this.getUser();
        return user == null ? null : user.getFullName();
    }

    public String getFullNameWithUserName() {
        return this.getUser() == null ? "" : this.getFullName() + " (" + this.getUserName() + ")";
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(ContentOwnerAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }

    public void setOwner(ConfluenceUser user) {
        if (user != null) {
            this.getActiveObject().setUserKey(user.getKey().getStringValue());
        }
    }
}

