/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ContentFlowUtils {
    public static final String PERMISSION_TYPE = "type";
    public static final String PERMISSION_USER_KEY = "user";
    public static final String PERMISSION_GROUP_NAME = "group";
    public static final String NOTIFICATION_KEY = "com.brikit.contentflow.notification";

    public static void addPageToIndexQueue(AbstractPage abstractPage) {
        Confluence.addAbstractPageToIndexQueueForUpdate(abstractPage, false);
    }

    protected static String contentPermissionsJSON(Collection<ContentPermission> permissions) {
        JSONArray permissionsJSON = new JSONArray();
        for (ContentPermission permission : permissions) {
            JSONObject permissionJSON = new JSONObject();
            permissionJSON.put((Object)PERMISSION_TYPE, (Object)permission.getType());
            permissionJSON.put((Object)PERMISSION_USER_KEY, permission.isUserPermission() ? permission.getUserSubject().getKey().getStringValue() : null);
            permissionJSON.put((Object)PERMISSION_GROUP_NAME, (Object)(permission.isGroupPermission() ? permission.getGroupName() : null));
            permissionsJSON.add((Object)permissionJSON);
        }
        return permissionsJSON.toJSONString();
    }

    public static void setEditPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        if (permissionSet == null) {
            permissionSet = ContentFlowUtils.getOpenEditPermissions(abstractPage);
        }
        Confluence.setContentPermissions(permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)abstractPage, "Edit");
    }

    public static void setViewPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        if (permissionSet == null) {
            permissionSet = ContentFlowUtils.getOpenViewPermissions(abstractPage);
        }
        Confluence.setContentPermissions(permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)abstractPage, "View");
    }

    public static Collection<ContentPermission> getContentPermissionsFromJSON(String permissionsjSON) {
        HashSet<ContentPermission> contentPermissions = new HashSet<ContentPermission>();
        try {
            JSONParser parser = new JSONParser();
            JSONArray permissionsArray = (JSONArray)parser.parse(permissionsjSON);
            for (Object next : permissionsArray) {
                ContentPermission permission;
                JSONObject json = (JSONObject)next;
                String type = (String)json.get((Object)PERMISSION_TYPE);
                String userKey = (String)json.get((Object)PERMISSION_USER_KEY);
                String groupName = (String)json.get((Object)PERMISSION_GROUP_NAME);
                if (BrikitString.isSet(userKey)) {
                    ConfluenceUser user = Confluence.getConfluenceUserByUserKey(userKey);
                    permission = ContentPermission.createUserPermission((String)type, (ConfluenceUser)user);
                } else {
                    permission = ContentPermission.createGroupPermission((String)type, (String)groupName);
                }
                contentPermissions.add(permission);
            }
        }
        catch (ParseException ex) {
            BrikitLog.logError("Failed to parse permissions from string: " + permissionsjSON, (Exception)((Object)ex));
        }
        return contentPermissions;
    }

    public static ContentPermissionSet getOpenEditPermissions(AbstractPage abstractPage) {
        return new ContentPermissionSet("Edit", (ContentEntityObject)abstractPage);
    }

    public static ContentPermissionSet getOpenViewPermissions(AbstractPage abstractPage) {
        return new ContentPermissionSet("View", (ContentEntityObject)abstractPage);
    }

    public static boolean jsonHasKeyNotNull(JSONObject json, String key) {
        return json.containsKey((Object)key) && BrikitString.isSet((String)json.get((Object)key));
    }

    protected static String toJSON(ContentPermissionSet permissionSet) {
        return ContentFlowUtils.contentPermissionsJSON(permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST));
    }
}

