/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldNames;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.brikit.contentflow.model.ArchivePolicy;
import com.brikit.contentflow.model.ArchiveReason;
import com.brikit.contentflow.model.ArchivedPage;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.ContentOwner;
import com.brikit.contentflow.model.LastPageView;
import com.brikit.contentflow.model.PageInReview;
import com.brikit.contentflow.model.ao.PageInReviewAO;
import com.brikit.contentflow.model.query.PageInReviewQuery;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.search.CQLComposer;
import com.brikit.core.search.PagingCQLSearcher;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import net.java.ao.EntityStreamCallback;

public class Archiver {
    protected static final String ARCHIVE_KEY_TITLE_DELIMITER = ":";

    public static boolean archive(ActiveObjects activeObjects, AbstractPage abstractPage, ArchiveReason archiveReason) {
        if (abstractPage == null) {
            BrikitLog.logError("No page or blogpost is available to archive.");
            return false;
        }
        if (ArchivedPage.getArchivedPageAO(activeObjects, abstractPage.getId()) != null) {
            BrikitLog.logError("Archive record already exists when trying to archive " + abstractPage);
            return false;
        }
        try {
            ContentFlowConfiguration contentFlowConfiguration;
            ArchivePolicy archivePolicy;
            String archiveMessage = "Archived " + abstractPage;
            ArchivedPage archivedPage = ArchivedPage.create(activeObjects, abstractPage);
            PageInReview pageInReview = PageInReview.getPageInReviewForPage(activeObjects, abstractPage);
            if (pageInReview != null) {
                pageInReview.delete();
            }
            if ((archivePolicy = (contentFlowConfiguration = ContentFlowConfiguration.forPage(activeObjects, abstractPage)).getArchivePolicy()) != null && archivePolicy.isArchiveToSpace()) {
                String originalSpaceKey = Confluence.getSpaceKey(abstractPage);
                Space archiveSpace = archivePolicy.getArchiveSpace();
                String spaceMarkedTitle = originalSpaceKey + ARCHIVE_KEY_TITLE_DELIMITER + Confluence.getTitle(abstractPage);
                Page archiveHomePage = Confluence.getSpaceHomePage(archiveSpace);
                if (archiveHomePage == null) {
                    BrikitLog.logError("Can't archive page " + abstractPage + " because archiver cannot access home page for archive space " + archivePolicy.getArchiveSpaceKey());
                    return false;
                }
                if (Confluence.isPage(abstractPage)) {
                    Confluence.movePage((Page)abstractPage, Confluence.getSpaceHomePage(archiveSpace));
                } else {
                    Confluence.moveBlogPost((BlogPost)abstractPage, archiveSpace);
                }
                Confluence.setPageTitle(abstractPage, spaceMarkedTitle);
                BrikitLog.log(archiveMessage + " to " + archiveSpace);
            } else {
                Confluence.trashPage(abstractPage);
                BrikitLog.log(archiveMessage + " to space trash");
            }
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to archive: " + abstractPage, ex);
            return false;
        }
        return true;
    }

    public static void archiveUnreviewedPages(final ActiveObjects activeObjects, final LocalNotificationService notificationService) {
        PageInReviewQuery query = new PageInReviewQuery(activeObjects);
        BrikitLog.log("Archiving unreviewed pages...");
        final int[] count = new int[]{0};
        query.streamQuery(query.queryPageInReviews(), (EntityStreamCallback)new EntityStreamCallback<PageInReviewAO, Integer>(){

            public void onRowRead(PageInReviewAO readOnlyAO) {
                PageInReviewAO pageInReviewAO = (PageInReviewAO)activeObjects.get(PageInReviewAO.class, (Object)readOnlyAO.getID());
                PageInReview pageInReview = new PageInReview(activeObjects, pageInReviewAO);
                AbstractPage abstractPage = pageInReview.getAbstractPage();
                if (!Archiver.canArchive(activeObjects, abstractPage)) {
                    return;
                }
                Calendar reviewByDate = pageInReview.getReviewByDate();
                if (reviewByDate != null && BrikitDate.isAfter(BrikitDate.getToday(), reviewByDate)) {
                    BrikitLog.log("Archiving: " + pageInReview.getAbstractPage());
                    if (Archiver.archive(activeObjects, pageInReview.getAbstractPage(), ArchiveReason.EXPIRED)) {
                        count[0] = count[0] + 1;
                        Archiver.notifyContentOwnerForArchive(activeObjects, notificationService, pageInReview.getAbstractPage());
                    }
                }
            }
        });
        BrikitLog.log("Archived " + count + " unreviewed pages.");
    }

    public static boolean canArchive(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (Confluence.isPage(abstractPage) && ((Page)abstractPage).hasChildren()) {
            return false;
        }
        ContentFlowConfiguration contentFlowConfiguration = ContentFlowConfiguration.forPage(activeObjects, abstractPage);
        return contentFlowConfiguration != null && contentFlowConfiguration.hasArchivePolicy() && !Archiver.isArchived(activeObjects, abstractPage);
    }

    protected static boolean flagPageForReview(ActiveObjects activeObjects, LocalNotificationService notificationService, ArchivePolicy archivePolicy, long pageId) {
        PageInReview pageInReview = PageInReview.getPageInReviewForPage(activeObjects, pageId);
        if (pageInReview == null) {
            pageInReview = PageInReview.create(activeObjects, pageId, archivePolicy);
            Archiver.notifyContentOwnerForReview(activeObjects, notificationService, Confluence.getPageOrBlogPost(pageId));
            BrikitLog.log("Flagging for review: " + pageInReview.getAbstractPage());
            return true;
        }
        PageInReview.addReviewLabel(activeObjects, Confluence.getPageOrBlogPost(pageId), archivePolicy);
        return false;
    }

    public static void flagPagesNeedingReview(ActiveObjects activeObjects, LocalNotificationService notificationService) {
        try {
            for (Space space : Confluence.getAllSpaces()) {
                int count;
                ContentFlowConfiguration contentFlowConfiguration = ContentFlowConfiguration.forSpace(activeObjects, space.getKey());
                ArchivePolicy archivePolicy = contentFlowConfiguration.getArchivePolicy();
                if (archivePolicy == null || (count = Archiver.flagPagesNeedingReviewInSpaceWithReviewPolicy(activeObjects, notificationService, space, archivePolicy)) <= 0) continue;
                BrikitLog.log("Flagged " + count + " pages for review.");
            }
        }
        catch (InvalidSearchException ex) {
            BrikitLog.logError("Unable to search for pages that should be flagged for review. Stopping searching.", (Exception)((Object)ex));
        }
    }

    protected static int flagPagesNeedingReviewInSpaceWithReviewPolicy(ActiveObjects activeObjects, LocalNotificationService notificationService, Space space, ArchivePolicy archivePolicy) throws InvalidSearchException {
        return archivePolicy.isReviewAfterLastView() ? Archiver.flagPagesNotViewed(activeObjects, notificationService, space, archivePolicy) : Archiver.flagPagesNotUpdated(activeObjects, notificationService, space, archivePolicy);
    }

    protected static int flagPagesNotUpdated(ActiveObjects activeObjects, LocalNotificationService notificationService, Space space, ArchivePolicy archivePolicy) throws InvalidSearchException {
        int reviewDaysAfterPublished = archivePolicy.getReviewDaysAfterPublished();
        Calendar cutoffDate = BrikitDate.addDays(Confluence.getSystemTimeNow(), -1 * reviewDaysAfterPublished);
        CQLComposer cqlComposer = new CQLComposer();
        cqlComposer.setSpaceSearchScope(space.getKey());
        BrikitList<String> types = new BrikitList<String>();
        types.add("page");
        types.add("blogpost");
        cqlComposer.setContentTypes(types);
        cqlComposer.setLastModified("< " + BrikitDate.formatSimpleDate(cutoffDate));
        PagingCQLSearcher cqlSearcher = new PagingCQLSearcher();
        PageResponse<Content> pageResponse = cqlSearcher.search(cqlComposer.cql(), 0, Integer.MAX_VALUE);
        int count = 0;
        for (Content result : pageResponse.getResults()) {
            if (!Archiver.flagPageForReview(activeObjects, notificationService, archivePolicy, result.getId().asLong())) continue;
            ++count;
        }
        return count;
    }

    protected static int flagPagesNotViewed(ActiveObjects activeObjects, LocalNotificationService notificationService, Space space, ArchivePolicy archivePolicy) throws InvalidSearchException {
        int days = archivePolicy.getReviewDaysAfterPublished();
        BrikitList<LastPageView> pagesNotViewed = LastPageView.getPagesNotViewedInDays(activeObjects, space.getKey(), days);
        int count = 0;
        for (LastPageView lastPageView : pagesNotViewed) {
            if (!Archiver.flagPageForReview(activeObjects, notificationService, archivePolicy, lastPageView.getPageId())) continue;
            ++count;
        }
        return count;
    }

    protected static ImmutableSet<String> getFieldsToFetchForFlaggingPagesForReview() {
        return SearchFieldNames.createWithDefaultValues((String[])new String[]{"spacekey", "space-name", "title", "type", "modified"});
    }

    public static boolean isArchived(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage != null && ArchivedPage.getArchivedPageForPage(activeObjects, abstractPage) != null;
    }

    protected static void notifyContentOwner(ActiveObjects activeObjects, LocalNotificationService notificationService, AbstractPage abstractPage, String title, String description) {
        ConfluenceUser user;
        ContentOwner owner = ContentOwner.getContentOwner(activeObjects, abstractPage.getId());
        ConfluenceUser confluenceUser = user = owner == null ? abstractPage.getCreator() : owner.getUser();
        if (user == null) {
            BrikitLog.logWarning("Unable to send review notification. No owner or creator found for page: " + abstractPage);
            return;
        }
        try {
            notificationService.createOrUpdate(user.getName(), new NotificationBuilder().application("com.brikit.contentflow").title(title).entity(abstractPage.getDisplayTitle()).itemTitle(description).description("<h2>" + Confluence.getPageLinkHTML(abstractPage) + "</h2>").groupingId("com.brikit.contentflow.notification").createNotification()).get();
        }
        catch (Exception ex) {
            BrikitLog.logError("Notification error sending " + title + " to user: " + user.getName() + " for page: " + abstractPage, ex);
        }
    }

    protected static void notifyContentOwnerForArchive(ActiveObjects activeObjects, LocalNotificationService notificationService, AbstractPage abstractPage) {
        Archiver.notifyContentOwner(activeObjects, notificationService, abstractPage, Confluence.getText("com.brikit.contentflow.notification.page.archived.title", new Object[]{abstractPage.getDisplayTitle()}), Confluence.getText("com.brikit.contentflow.notification.page.archived.description"));
    }

    protected static void notifyContentOwnerForReview(ActiveObjects activeObjects, LocalNotificationService notificationService, AbstractPage abstractPage) {
        Archiver.notifyContentOwner(activeObjects, notificationService, abstractPage, Confluence.getText("com.brikit.contentflow.notification.review.needed.title", new Object[]{abstractPage.getDisplayTitle()}), Confluence.getText("com.brikit.contentflow.notification.review.needed.description"));
    }

    public static void unarchiveFromArchiveSpace(ArchivedPage archivedPage) {
        AbstractPage abstractPage = archivedPage.getAbstractPage();
        try {
            BrikitList<String> titleBits = BrikitString.splitOnFirst(Confluence.getTitle(abstractPage), ARCHIVE_KEY_TITLE_DELIMITER);
            String originalSpaceKey = titleBits.size() == 2 ? titleBits.first() : Confluence.getSpaceKey(abstractPage);
            String originalPageTitle = titleBits.last();
            if (Confluence.isPage(abstractPage)) {
                long originalParentId;
                Page currentParent = Confluence.getParent((Page)abstractPage);
                long currentParentId = currentParent == null ? 0L : currentParent.getId();
                if (currentParentId != (originalParentId = archivedPage.getOriginalParentPageId())) {
                    Page originalParent = (Page)Confluence.getPageOrBlogPost(originalParentId);
                    if (originalParent == null) {
                        originalParent = Confluence.getSpaceHomePage(originalSpaceKey);
                    }
                    Confluence.movePage((Page)abstractPage, originalParent);
                }
            } else {
                String currentSpaceKey = Confluence.getSpaceKey(abstractPage);
                if (!originalSpaceKey.equals(currentSpaceKey)) {
                    Confluence.moveBlogPost((BlogPost)abstractPage, originalSpaceKey);
                }
            }
            if (!originalPageTitle.equals(Confluence.getTitle(abstractPage))) {
                Confluence.setPageTitle(abstractPage, originalPageTitle);
            }
            Confluence.savePage(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), Confluence.getText("com.brikit.contentflow.page.restored.from.archive"), false);
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to restore from archive space: " + abstractPage, ex);
        }
    }

    public static void unarchivedFromSpaceTrash(ArchivedPage archivedPage) {
        AbstractPage abstractPage = archivedPage.getAbstractPage();
        try {
            AbstractPage originalParent = archivedPage.getOriginalParentPage();
            if (originalParent != null) {
                Confluence.movePage((Page)archivedPage.getAbstractPage(), (Page)originalParent);
            }
            archivedPage.delete();
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to restore from archive in space trash: " + abstractPage, ex);
        }
    }
}

