/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.contentflow.model.PageReviewFeedback;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.contentflow.model.UserDelegate;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.model.ao.ApprovalStepAO;
import com.brikit.contentflow.model.ao.ReviewerAO;
import com.brikit.contentflow.model.query.PageReviewFeedbackQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ApprovalStep
extends AbstractActiveObjectsModel {
    public static final String REVIEWERS_KEY = "reviewers";
    protected static final String PAGE_STATUS_ID_KEY = "pageStatusId";
    protected ApprovalStepAO activeObject;
    protected Workflow workflow;
    protected List<Reviewer> reviewers;
    protected PageStatus pageStatus;

    protected ApprovalStep(ActiveObjects activeObjects, ApprovalStepAO activeObject) {
        this(activeObjects, activeObject, null);
    }

    protected ApprovalStep(ActiveObjects activeObjects, ApprovalStepAO activeObject, Workflow workflow) {
        super(activeObjects);
        this.activeObject = activeObject;
        this.workflow = workflow;
    }

    public static ApprovalStep create(ActiveObjects activeObjects, Workflow workflow, int position) {
        ApprovalStepAO approvalStepAO = (ApprovalStepAO)activeObjects.create(ApprovalStepAO.class, new DBParam[0]);
        approvalStepAO.setWorkflowAO(workflow.getActiveObject());
        approvalStepAO.setPosition(position);
        ApprovalStep approvalStep = new ApprovalStep(activeObjects, approvalStepAO, workflow);
        approvalStep.save();
        return approvalStep;
    }

    public static ApprovalStep create(ActiveObjects activeObjects, Workflow workflow, int position, JSONArray reviewersJSON, Long pageStatusKey) throws Exception {
        ApprovalStep approvalStep = ApprovalStep.create(activeObjects, workflow, position);
        for (int i = 0; i < reviewersJSON.size(); ++i) {
            JSONObject reviewerJSON = (JSONObject)reviewersJSON.get(i);
            Reviewer.create(activeObjects, approvalStep, i + 1, reviewerJSON);
        }
        approvalStep.setPageStatusFromKey(pageStatusKey);
        approvalStep.save();
        return approvalStep;
    }

    protected static BrikitList<ApprovalStep> fromActiveObjects(ActiveObjects activeObjects, ApprovalStepAO[] approvalStepAOs) {
        BrikitList<ApprovalStep> approvalSteps = new BrikitList<ApprovalStep>(approvalStepAOs.length);
        for (ApprovalStepAO approvalStepAO : approvalStepAOs) {
            approvalSteps.add(new ApprovalStep(activeObjects, approvalStepAO));
        }
        return approvalSteps;
    }

    public Reviewer addReviewer(JSONObject reviewerJSON) throws Exception {
        Reviewer lastReviewer = new BrikitList<Reviewer>(this.getReviewers()).last();
        int position = lastReviewer == null ? 1 : lastReviewer.getPosition() + 1;
        Reviewer newReviewer = Reviewer.create(this.getActiveObjects(), this, position, reviewerJSON);
        return newReviewer;
    }

    public void delete() {
        for (Reviewer reviewer : this.getReviewers()) {
            reviewer.setActiveObjects(this.getActiveObjects());
            reviewer.delete();
        }
        for (PageWorkflow pageWorkflow : PageWorkflow.getPageWorkflowsReferencingApprovalStep(this.getActiveObjects(), this)) {
            pageWorkflow.clearCurrentApprovalStepReference();
        }
        for (PageReviewFeedback pageReviewFeedback : PageReviewFeedback.getPageReviewFeedbackReferencingApprovalStep(this.getActiveObjects(), this)) {
            pageReviewFeedback.clearApprovalStepReference();
        }
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public ApprovalStepAO getActiveObject() {
        return this.activeObject;
    }

    public int getApprovalsNeeded() {
        return this.getActiveObject().getApprovalsNeeded();
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public String getLabel() {
        return this.getPageStatus() == null ? null : this.getPageStatus().getLabel();
    }

    protected String getLabelsString() {
        return this.getActiveObject().getLabels();
    }

    public int getPosition() {
        return this.getActiveObject().getPosition();
    }

    public PageStatus getPageStatus() {
        if (this.pageStatus == null && this.getActiveObject().getPageStatusAO() != null) {
            this.pageStatus = new PageStatus(this.getActiveObjects(), this.getActiveObject().getPageStatusAO());
        }
        return this.pageStatus;
    }

    public Reviewer getReviewerWithID(int id) {
        for (Reviewer reviewer : this.getReviewers()) {
            if (reviewer.getID() != id) continue;
            return reviewer;
        }
        return null;
    }

    public List<Reviewer> getReviewers() {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<Reviewer>();
            if (this.getActiveObject().getReviewerAOs() == null) {
                return this.reviewers;
            }
            for (ReviewerAO reviewerAO : Arrays.asList(this.getActiveObject().getReviewerAOs())) {
                this.reviewers.add(new Reviewer(this.getActiveObjects(), reviewerAO));
            }
            Collections.sort(this.reviewers, new Comparator<Reviewer>(){

                @Override
                public int compare(Reviewer reviewer, Reviewer reviewer2) {
                    return reviewer.getPosition() - reviewer2.getPosition();
                }
            });
        }
        return this.reviewers;
    }

    public Workflow getWorkflow() {
        if (this.workflow == null) {
            this.workflow = new Workflow(this.getActiveObjects(), this.getActiveObject().getWorkflowAO());
        }
        return this.workflow;
    }

    public boolean hasApprovalActivity() {
        return this.hasPageReviewFeedback();
    }

    public boolean hasNextStep() {
        return this.nextStep() != null;
    }

    public boolean hasPageReviewFeedback() {
        PageReviewFeedbackQuery query = new PageReviewFeedbackQuery(this.activeObjects);
        return query.countPageReviewFeedback(this.getActiveObject()) > 0;
    }

    public boolean hasPreviousStep() {
        return this.previousStep() != null;
    }

    public boolean isCurrentUserReviewer() {
        return this.isReviewer(Confluence.getConfluenceUser());
    }

    public boolean isFirstStep() {
        return this.getWorkflow().isFirstStep(this);
    }

    public boolean isPublishingEditorOrWorkflowEditor(AbstractPage abstractPage) {
        return this.isFirstStep() && (!this.getWorkflow().isPublishing() || Confluence.canEdit(abstractPage));
    }

    public boolean isReviewer(ConfluenceUser aUser) {
        return this.isReviewerByName(aUser) || this.isReviewerByGroup(aUser) || this.isReviewerByDelegate(aUser);
    }

    public boolean isReviewerByDelegate(ConfluenceUser aUser) {
        return this.reviewerByDelegate(aUser) != null;
    }

    public boolean isReviewerByGroup(ConfluenceUser aUser) {
        return this.reviewerByGroup(aUser) != null;
    }

    public boolean isReviewerByName(ConfluenceUser aUser) {
        return this.reviewerByName(aUser) != null;
    }

    public ApprovalStep nextStep() {
        return this.getWorkflow().nextStep(this);
    }

    public ApprovalStep previousStep() {
        return this.getWorkflow().previousStep(this);
    }

    protected Reviewer reviewerByDelegate(ConfluenceUser user) {
        UserDelegate userDelegate = UserDelegate.getUserDelegateForDelegate(this.getActiveObjects(), user);
        if (userDelegate == null) {
            return null;
        }
        Reviewer reviewer = this.reviewerByName(userDelegate.getDelegatingUser());
        if (reviewer != null) {
            return reviewer;
        }
        reviewer = this.reviewerByGroup(userDelegate.getDelegatingUser());
        if (reviewer != null) {
            return reviewer;
        }
        return null;
    }

    protected Reviewer reviewerByName(ConfluenceUser user) {
        if (user == null) {
            return null;
        }
        for (Reviewer reviewer : this.getReviewers()) {
            if (!reviewer.isReviewerByName(user)) continue;
            return reviewer;
        }
        return null;
    }

    protected Reviewer reviewerByGroup(ConfluenceUser user) {
        if (user == null) {
            return null;
        }
        for (Reviewer reviewer : this.getReviewers()) {
            if (!reviewer.isReviewerByGroup(user)) continue;
            return reviewer;
        }
        return null;
    }

    public Reviewer reviewerForUser(ConfluenceUser user) {
        Reviewer reviewer = this.reviewerByName(user);
        if (reviewer != null) {
            return reviewer;
        }
        reviewer = this.reviewerByGroup(user);
        if (reviewer != null) {
            return reviewer;
        }
        reviewer = this.reviewerByDelegate(user);
        return reviewer;
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(ApprovalStepAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setApprovalsNeeded(int approvalsNeeded) {
        this.getActiveObject().setApprovalsNeeded(approvalsNeeded);
    }

    public void setLabels(String labelsString) {
        this.getActiveObject().setLabels(BrikitString.splitCommaSeparated(labelsString).first());
    }

    protected void setPageStatusFromKey(Long pageStatusKey) {
        this.pageStatus = pageStatusKey == null ? null : PageStatus.getPageStatus(this.getActiveObjects(), pageStatusKey);
        this.getActiveObject().setPageStatusAO(this.pageStatus == null ? null : this.pageStatus.getActiveObject());
    }

    public void setPosition(int position) {
        this.getActiveObject().setPosition(position);
    }

    public void update(JSONObject approvalStepJSON) throws Exception {
        long approvalStepID = (Long)approvalStepJSON.get((Object)"id");
        if ((long)this.getID() != approvalStepID) {
            throw new Exception(Confluence.getText("com.brikit.contentflow.approval.step.ids.do.not.match"));
        }
        int oldIndex = 0;
        int newIndex = 0;
        List<Reviewer> oldReviewers = this.getReviewers();
        JSONArray newReviewers = (JSONArray)approvalStepJSON.get((Object)REVIEWERS_KEY);
        if (newReviewers.size() == 0) {
            this.delete();
            return;
        }
        while (oldIndex < oldReviewers.size() || newIndex < newReviewers.size()) {
            JSONObject newReviewerJSON;
            Reviewer oldReviewer = oldIndex < oldReviewers.size() ? oldReviewers.get(oldIndex) : null;
            JSONObject jSONObject = newReviewerJSON = newIndex < newReviewers.size() ? (JSONObject)newReviewers.get(newIndex) : null;
            if (oldReviewer != null) {
                oldReviewer.setActiveObjects(this.getActiveObjects());
            }
            if (oldReviewer == null) {
                this.addReviewer(newReviewerJSON);
                ++newIndex;
                continue;
            }
            if (newReviewerJSON == null) {
                oldReviewer.delete();
                ++oldIndex;
                continue;
            }
            if ((Long)newReviewerJSON.get((Object)"id") == 0L) {
                this.addReviewer(newReviewerJSON);
                ++newIndex;
                continue;
            }
            if ((long)oldReviewer.getID() == (Long)newReviewerJSON.get((Object)"id")) {
                oldReviewer.update(newReviewerJSON);
                ++oldIndex;
                ++newIndex;
                continue;
            }
            oldReviewer.delete();
            ++oldIndex;
        }
        this.setPageStatusFromKey((Long)approvalStepJSON.get((Object)PAGE_STATUS_ID_KEY));
        this.save();
    }
}

