/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.PageRestricter;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Publisher;
import com.brikit.contentflow.model.ScheduledPage;
import com.brikit.core.util.BrikitDate;
import java.text.ParseException;
import java.util.Date;

public class SchedulePageAction
extends ContentFlowActionSupport {
    public static final String SCHEDULER_DATE_FORMAT = "yyyy-MM-dd h:mm a";
    protected String releaseDate;
    protected String releaseTime;
    protected String hideDate;
    protected String hideTime;

    public String getHideDate() {
        return this.hideDate;
    }

    protected Date getHideDateTime() {
        return this.parseDateTime(this.getHideDate(), this.getHideTime());
    }

    public String getHideTime() {
        return this.hideTime;
    }

    public boolean getPageHasAnyRestrictions() {
        PageRestricter pageRestricter = new PageRestricter(this.getActiveObjects(), this.getPage());
        return pageRestricter.hasPageViewRestrictions();
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    protected Date getReleaseDateTime() {
        return this.parseDateTime(this.getReleaseDate(), this.getReleaseTime());
    }

    public String getReleaseTime() {
        return this.releaseTime;
    }

    public boolean isNewPageUnderAutomaticPublishingWorkflow() {
        return Publisher.isNewPageUnderAutomaticPublishingWorkflow(this.getActiveObjects(), this.getPage());
    }

    public boolean isPublishingWorkflowInEffect() {
        PageWorkflow workflow = PageWorkflow.getPageWorkflow(this.getActiveObjects(), this.getPage());
        return workflow != null && workflow.isPublishing() && !workflow.isComplete();
    }

    protected Date parseDateTime(String dateString, String timeString) {
        try {
            return BrikitDate.parseDateForUserTimeZone(SCHEDULER_DATE_FORMAT, dateString + " " + timeString);
        }
        catch (ParseException ex) {
            this.addActionError("Unable to parse date/time: " + dateString + " " + timeString);
            return null;
        }
    }

    public String save() {
        if (this.getReleaseDateTime() == null && this.getHideDateTime() == null) {
            ScheduledPage.unschedule(this.getActiveObjects(), this.getPage());
        } else {
            ScheduledPage.schedulePage(this.getActiveObjects(), this.getPage(), this.getReleaseDateTime(), this.getHideDateTime());
        }
        return "success";
    }

    public void setHideDate(String hideDate) {
        this.hideDate = hideDate;
    }

    public void setHideTime(String hideTime) {
        this.hideTime = hideTime;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public void setReleaseTime(String releaseTime) {
        this.releaseTime = releaseTime;
    }
}

