/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.ContentFlow;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.PageApprovalStep;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;

public class PageWorkflowStatusAction
extends ContentFlowActionSupport {
    @Override
    public String execute() {
        JSONObject json = new JSONObject();
        if (!ContentFlow.isLicensed(this.getPluginLicenseManager())) {
            json.put("unlicensed", true);
        } else if (ContentFlowConfiguration.canUseWorkflows(this.getActiveObjects(), this.getSpaceKey()) && this.getWorkflowPermissions().canSeeWorkflows(this.getPageId())) {
            json.put("contentFlowEnabled", true);
            json.put("canEdit", Confluence.canEditPage(this.getPageId()));
            if (this.hasPageWorkflow()) {
                json.put("active", true);
                json.put("id", this.getPageWorkflow().getID());
                json.put("publishOnApproval", this.getPageWorkflow().isPublishing());
                json.put("complete", this.getPageWorkflow().isComplete());
                json.put("waitingForUser", this.getPageWorkflow().currentUserNeedsToApprove());
                JSONArray steps = new JSONArray();
                for (PageApprovalStep pageApprovalStep : this.getPageWorkflow().getPageApprovalSteps()) {
                    steps.put((Object)(pageApprovalStep.isComplete() ? "complete" : "pending"));
                }
                json.put("stepStates", (Object)steps);
            }
            if (this.hasScheduledPage()) {
                json.put("scheduled", true);
                if (this.getScheduledPage().isBeforeReleaseTime()) {
                    json.put("publishOn", (Object)BrikitDate.formatDateTime(this.getScheduledPage().getReleaseTime(), Confluence.getUserTimeZone()));
                }
                if (this.getScheduledPage().hasHideTime()) {
                    json.put("archiveOn", (Object)BrikitDate.formatDateTime(this.getScheduledPage().getHideTime(), Confluence.getUserTimeZone()));
                }
            }
            if (this.hasArchivedPage()) {
                json.put("needsReview", this.hasArchivedPage());
            }
        }
        return this.setJSONSuccess(json);
    }
}

