/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.PublishedPage;
import com.brikit.contentflow.model.RestrictedPage;
import com.brikit.core.confluence.Confluence;

public class DeletePageWorkflowsAction
extends AbstractSpaceAction {
    protected ActiveObjects activeObjects;

    public String execute() throws Exception {
        for (PageWorkflow pageWorkflow : PageWorkflow.getAllPageWorkflows(this.getActiveObjects(), this.getSpace())) {
            pageWorkflow.removeFromPage();
        }
        for (PublishedPage publishedPage : PublishedPage.getAllPageWorkflows(this.getActiveObjects(), this.getSpace())) {
            publishedPage.delete();
        }
        for (RestrictedPage restrictedPage : RestrictedPage.getAllRestrictedPages(this.getActiveObjects(), this.getSpace())) {
            restrictedPage.removeFromPage();
        }
        return "success";
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public AbstractPage getPage() {
        return Confluence.getSpaceHomePage(this.getSpace());
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void validate() {
        super.validate();
        if (!Confluence.canAdministerSpace(this.getSpaceKey())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

