/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.AccessPermission;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.BlueprintFieldType;
import com.brikit.blueprintmaker.model.BlueprintListField;
import com.brikit.blueprintmaker.model.FieldSwapper;
import com.brikit.blueprintmaker.model.FieldValue;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.PageFields;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.blueprintmaker.model.SpaceFields;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContentMaker {
    protected String spaceName;
    protected String spaceKey;
    protected String spaceDescription;
    protected Page parentPage;
    protected Space newSpace;
    protected SpaceBlueprint spaceBlueprint;
    protected PageBlueprint pageBlueprint;
    protected FieldSwapper fieldSwapper;

    protected ContentMaker() {
    }

    public ContentMaker(SpaceBlueprint spaceBlueprint, String spaceName, String spaceKey, String spaceDescription, String valuesJSON, Map<String, AttachmentResource> fileResources) {
        this.spaceBlueprint = spaceBlueprint;
        this.spaceName = spaceName;
        this.spaceKey = spaceKey;
        this.spaceDescription = spaceDescription;
        this.getFieldSwapper().addValues(valuesJSON);
        this.getFieldSwapper().addFileResources(fileResources);
    }

    public ContentMaker(PageBlueprint pageBlueprint, Page parentPage, String valuesJSON, Map<String, AttachmentResource> fileResources) {
        this.pageBlueprint = pageBlueprint;
        this.parentPage = parentPage;
        this.getFieldSwapper().addValues(valuesJSON);
        this.getFieldSwapper().addFileResources(fileResources);
    }

    protected void checkPageBlueprintPermissions(String spaceKey) throws Exception {
        if (this.getPageBlueprint() == null) {
            return;
        }
        if (!this.getPageBlueprint().isVisibleInSpace(spaceKey)) {
            throw new Exception("Page blueprint " + this.getPageBlueprint().getName() + " is not visible in space: " + this.getDestinationSpace().getName() + " (" + this.getDestinationSpace().getKey() + ")");
        }
    }

    protected BlogPost createBlogpostFromBlueprint(BlogPost blueprintPage) throws Exception {
        BrikitLog.logDebug((String)("Creating blog post: " + blueprintPage.getTitle()));
        this.getFieldSwapper().resetForNewPage();
        this.getFieldSwapper().addValuesForDestination(Confluence.getSpaceKey((AbstractPage)blueprintPage));
        this.getFieldSwapper().setBlueprintPage((AbstractPage)blueprintPage);
        String pageTitle = this.getFieldSwapper().applyDataToPageTitle();
        String storageFormat = this.getFieldSwapper().applyDataToPageBody(this.getNewSpace());
        BlogPost blogpost = Confluence.createBlogPost((Space)this.getNewSpace(), (String)pageTitle, (String)storageFormat, (Calendar)blueprintPage.getPostingCalendarDate());
        PageFields.saveFieldsToPage((AbstractPage)blogpost, this.getFieldSwapper());
        this.updatePageWithPageId((AbstractPage)blogpost, storageFormat);
        this.transferBlueprintPageData((AbstractPage)blueprintPage, (AbstractPage)blogpost);
        return blogpost;
    }

    protected void createBlogpostsFromBlueprint() throws Exception {
        for (BlogPost blueprintPage : Confluence.getAllBlogPosts((Space)this.getBlueprintSpace())) {
            this.createBlogpostFromBlueprint(blueprintPage);
        }
    }

    public AbstractPage createPage(String pageTitle) throws Exception {
        if (this.getPageBlueprint().getConfluencePage() == null) {
            throw new Exception("Blueprint page " + this.getPageBlueprint().getSpaceKey() + ":" + this.getPageBlueprint().getPageTitle() + " not found");
        }
        if (this.getParentPage() == null) {
            throw new Exception("Destination parent page not found");
        }
        this.setNewSpace(Confluence.getSpace((AbstractPage)this.getParentPage()));
        Page blueprintPage = this.getPageBlueprint().getConfluencePage();
        Page page = this.createPageFromBlueprint(blueprintPage, this.getParentPage(), pageTitle, null);
        if (this.getPageBlueprint().includeChildren()) {
            this.createPagesFromBlueprint(Confluence.getPermittedChildren((Page)blueprintPage), page, blueprintPage);
        }
        return page;
    }

    protected Page createPageFromBlueprint(Page blueprintPage, Page parentPage, String pageTitleTemplate, Integer position) throws Exception {
        if (!Confluence.canCreate((String)this.getDestinationSpaceKey())) {
            throw new Exception("You don't have permission to create pages in space: " + this.getDestinationSpace().getName() + " (" + this.getDestinationSpace().getKey() + ")");
        }
        this.checkPageBlueprintPermissions(this.getDestinationSpaceKey());
        this.getFieldSwapper().resetForNewPage();
        this.getFieldSwapper().addValuesForDestination((AbstractPage)parentPage);
        this.getFieldSwapper().setBlueprintPage((AbstractPage)blueprintPage);
        String pageTitle = this.getFieldSwapper().applyDataToPageTitle(pageTitleTemplate);
        String storageFormat = this.getFieldSwapper().applyDataToPageBody(this.getNewSpace());
        if (this.hasPageBlueprint()) {
            this.getPageBlueprint().suspendAutomaticWorkflows();
        }
        Page page = Confluence.createPage((Space)this.getNewSpace(), (String)pageTitle, (String)storageFormat, (boolean)false, (Page)parentPage, null, null, (Integer)position);
        this.updatePageWithPageId((AbstractPage)page, storageFormat);
        this.transferBlueprintPageData((AbstractPage)blueprintPage, (AbstractPage)page);
        if (this.hasPageBlueprint()) {
            BrikitList labels = new BrikitList();
            for (BlueprintField field : this.getPageBlueprint().getBlueprintFieldsFromPageBlueprint()) {
                FieldValue fieldValue;
                BlueprintListField listField;
                if (!(field instanceof BlueprintListField) || !(listField = (BlueprintListField)field).isAddLabels() || (fieldValue = this.getFieldSwapper().getValue(listField.getId())) == null) continue;
                labels.addAll((Collection)((BrikitList)fieldValue.getConvertedValue()));
            }
            Confluence.addLabelsFromStrings((List)labels, (AbstractPage)page);
        }
        this.getFieldSwapper().saveAttachmentsToPage((AbstractPage)page);
        PageFields.saveFieldsToPage((AbstractPage)page, this.getFieldSwapper());
        if (this.hasPageBlueprint()) {
            this.getPageBlueprint().unsuspendAutomaticWorkflows();
            this.getPageBlueprint().applyWorkflow((AbstractPage)page);
        }
        return page;
    }

    protected void createPagesFromBlueprint(List<Page> blueprintPages, Page parentPage, Page blueprintSpaceHomePage) throws Exception {
        Page newHomePage = Confluence.getSpaceHomePage((Space)this.getNewSpace());
        ArrayList<Long> childPageIds = new ArrayList<Long>();
        for (Page blueprintPage : blueprintPages) {
            BrikitLog.logDebug((String)("Creating page from blueprint: " + blueprintPage.getTitle()));
            Page page = blueprintPage.getId() == blueprintSpaceHomePage.getId() ? newHomePage : this.createPageFromBlueprint(blueprintPage, parentPage, Confluence.getTitle((AbstractPage)blueprintPage), blueprintPage.getPosition());
            childPageIds.add(page.getId());
            this.createPagesFromBlueprint(Confluence.getPermittedChildren((Page)blueprintPage), page, blueprintSpaceHomePage);
        }
        if (parentPage != null) {
            Confluence.setChildPageOrder((Page)parentPage, childPageIds);
        }
    }

    public Space createSpace() throws Exception {
        if (this.getSpaceBlueprint().getBlueprintSpace() == null) {
            throw new Exception("Blueprint space " + this.getSpaceBlueprint().getBlueprintSpaceKey() + " not found");
        }
        if (Confluence.getSpace((String)this.getSpaceKey()) != null) {
            throw new Exception("Space with key " + this.getSpaceKey() + " already exists");
        }
        BrikitLog.logDebug((String)("Creating space " + this.getSpaceName() + " (" + this.getSpaceKey() + ")"));
        this.setNewSpace(Confluence.createPrivateSpace((String)this.getSpaceKey(), (String)this.getSpaceName(), (String)this.getSpaceDescription()));
        BrikitLog.logDebug((String)"Adding values to field swapper");
        this.getFieldSwapper().addValuesForDestination(this.getSpaceKey());
        BrikitLog.logDebug((String)"Copying space labels to new space");
        String labelString = this.getFieldSwapper().applyData(Confluence.getLabelString((Space)this.getBlueprintSpace()));
        Confluence.addSpaceLabels((List)BrikitString.split((String)labelString), (Space)this.getNewSpace());
        BrikitLog.logDebug((String)"Transferring space metadata");
        this.transferSpaceMetadata();
        BrikitLog.logDebug((String)"Transferring space templates");
        this.transferSpaceTemplates();
        BrikitLog.logDebug((String)"Adding space categories");
        ArrayList<String> spaceCategories = new ArrayList<String>();
        for (String blueprint : this.getSpaceBlueprint().getSpaceCategories()) {
            spaceCategories.add(this.getFieldSwapper().applyData(blueprint));
        }
        Confluence.addSpaceLabels(spaceCategories, (Space)this.getNewSpace());
        BrikitLog.logDebug((String)"Granting all space permissions to creator");
        Confluence.grantSpacePermissions((List)Confluence.allSpacePermissions(), (Space)this.getNewSpace());
        BrikitLog.logDebug((String)"Applying blueprint space permissions");
        for (Access access : this.getSpaceBlueprint().getAccesses()) {
            for (AccessPermission accessPermission : access.getPermissions()) {
                String userOrGroupName = this.getFieldSwapper().applyData(accessPermission.getUserOrGroup());
                if (accessPermission.isGroupPermission()) {
                    Confluence.grantSpacePermissionsToGroup(accessPermission.getPermissions(), (Space)this.getNewSpace(), (String)userOrGroupName);
                } else if (accessPermission.isUserPermission()) {
                    Confluence.grantSpacePermissions(accessPermission.getPermissions(), (Space)this.getNewSpace(), (ConfluenceUser)Confluence.getConfluenceUser((String)userOrGroupName));
                } else if (accessPermission.isAnonymousPermission()) {
                    Confluence.grantSpacePermissionsToAnonymous(accessPermission.getPermissions(), (Space)this.getNewSpace());
                }
                if (!accessPermission.isGroupPermission() || !accessPermission.isCreateGroup() || accessPermission.getGroup() != null) continue;
                Confluence.createGroup((String)userOrGroupName);
            }
        }
        BrikitLog.logDebug((String)"Setting space theme key");
        Confluence.setSpaceThemeKey((Space)this.getNewSpace(), (String)Confluence.getSpaceThemeKey((Space)this.getBlueprintSpace()));
        BrikitLog.logDebug((String)"Saving field data to space");
        SpaceFields.saveFieldsToSpace(this.getNewSpace(), this.getFieldSwapper());
        BrikitLog.logDebug((String)"Replacing home page from blueprint home page");
        Page blueprintHomePage = Confluence.getSpaceHomePage((Space)this.getBlueprintSpace());
        Page newHomePage = Confluence.getSpaceHomePage((Space)this.getNewSpace());
        this.updateHomePageFromBlueprint(newHomePage, blueprintHomePage);
        BrikitLog.logDebug((String)"Creating pages for new space");
        this.createPagesFromBlueprint(Confluence.getPermittedChildren((Space)this.getBlueprintSpace()), null, blueprintHomePage);
        BrikitLog.logDebug((String)"Creating blog posts for new space");
        this.createBlogpostsFromBlueprint();
        BrikitLog.logDebug((String)"Finished space from blueprint");
        return this.getNewSpace();
    }

    public Space getBlueprintSpace() {
        return this.getSpaceBlueprint().getBlueprintSpace();
    }

    public Page getParentPage() {
        return this.parentPage;
    }

    public Space getDestinationSpace() {
        return Confluence.getSpace((AbstractPage)this.getParentPage());
    }

    public String getDestinationSpaceKey() {
        return this.getParentPage() != null ? Confluence.getSpaceKey((AbstractPage)this.getParentPage()) : (this.getNewSpace() != null ? this.getNewSpace().getKey() : "");
    }

    public FieldSwapper getFieldSwapper() {
        if (this.fieldSwapper == null) {
            this.fieldSwapper = new FieldSwapper();
        }
        return this.fieldSwapper;
    }

    public Space getNewSpace() {
        return this.newSpace;
    }

    public PageBlueprint getPageBlueprint() {
        return this.pageBlueprint;
    }

    public Page getPageBlueprintPage() {
        return this.getPageBlueprint() != null ? this.getPageBlueprint().getConfluencePage() : null;
    }

    public SpaceBlueprint getSpaceBlueprint() {
        return this.spaceBlueprint;
    }

    public String getSpaceDescription() {
        return this.spaceDescription;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    protected boolean hasPageBlueprint() {
        return this.getPageBlueprint() != null;
    }

    public AbstractPage recreatePageFromBlueprint(AbstractPage page, Page blueprintPage, boolean spaceBlueprint, String newPageTitle) throws Exception {
        Page parentPage;
        if (blueprintPage == null) {
            blueprintPage = this.getPageBlueprintPage();
        }
        this.getFieldSwapper().resetForNewPage();
        Page page2 = parentPage = Confluence.isPage((AbstractPage)page) ? ((Page)page).getParent() : null;
        if (parentPage == null) {
            this.getFieldSwapper().addValuesForDestination(Confluence.getSpaceKey((AbstractPage)page));
        } else {
            this.getFieldSwapper().addValuesForDestination((AbstractPage)parentPage);
        }
        this.getFieldSwapper().setBlueprintPage((AbstractPage)blueprintPage);
        String pageTitle = this.getFieldSwapper().applyDataToPageTitle(spaceBlueprint ? this.getSpaceBlueprint().getHomePageTitleBlueprint() : newPageTitle);
        String storageFormat = this.getFieldSwapper().applyDataToPageBody(Confluence.getSpace((AbstractPage)page));
        Integer position = null;
        if (Confluence.isPage((AbstractPage)page)) {
            position = spaceBlueprint ? blueprintPage.getPosition() : ((Page)page).getPosition();
        }
        Confluence.savePageTitleAndBody((AbstractPage)page, (String)pageTitle, (String)storageFormat, (String)"Updated from blueprint", (boolean)false, (Integer)position);
        this.updatePageWithPageId(page, storageFormat);
        this.transferBlueprintPageData((AbstractPage)blueprintPage, page);
        PageFields.saveFieldsToPage(page, this.getFieldSwapper());
        this.getFieldSwapper().saveAttachmentsToPage(page);
        return page;
    }

    public void setNewSpace(Space newSpace) {
        this.newSpace = newSpace;
    }

    public void setSpaceDescription(String spaceDescription) {
        this.spaceDescription = spaceDescription;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    protected void transferAttachments(AbstractPage fromPage, AbstractPage toPage) {
        Confluence.copyAttachments((AbstractPage)fromPage, (AbstractPage)toPage);
    }

    protected void transferBlueprintPageData(AbstractPage blueprintPage, AbstractPage destinationPage) throws IOException {
        this.transferLabels(blueprintPage, destinationPage);
        this.transferAttachments(blueprintPage, destinationPage);
        this.transferPageMetadata(blueprintPage, destinationPage);
        this.transferRestrictions(blueprintPage, destinationPage);
    }

    protected void transferLabels(AbstractPage fromPage, AbstractPage toPage) {
        Confluence.syncLabels((AbstractPage)toPage, (String)Confluence.getLabelString((AbstractPage)fromPage));
    }

    protected void transferPageMetadata(AbstractPage fromPage, AbstractPage toPage) {
        Confluence.copyPageMetadata((AbstractPage)fromPage, (AbstractPage)toPage, BlueprintDefinitions.getPageMetadata());
    }

    protected void transferRestrictions(AbstractPage fromPage, AbstractPage toPage) {
        ContentPermissionSet permissionSet = Confluence.getPageViewRestrictions((AbstractPage)fromPage);
        if (permissionSet != null) {
            Confluence.setContentPermissions((Collection)permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)toPage, (String)"View");
        }
        if ((permissionSet = Confluence.getPageEditRestrictions((AbstractPage)fromPage)) != null) {
            Confluence.setContentPermissions((Collection)permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)toPage, (String)"Edit");
        }
    }

    protected void transferSpaceMetadata() {
        Confluence.copySpaceMetadata((Space)this.getBlueprintSpace(), (Space)this.getNewSpace(), BlueprintDefinitions.getSpaceMetadata());
    }

    protected void transferSpaceTemplates() {
        for (PageTemplate fromTemplate : this.getBlueprintSpace().getPageTemplates()) {
            PageTemplate toTemplate = new PageTemplate(fromTemplate);
            this.getNewSpace().addPageTemplate(toTemplate);
            Confluence.getPageTemplateManager().savePageTemplate(toTemplate, null);
            Confluence.syncLabels((PageTemplate)toTemplate, (String)Confluence.getLabelString((PageTemplate)fromTemplate));
        }
    }

    protected AbstractPage updateHomePageFromBlueprint(Page page, Page blueprintPage) throws Exception {
        return this.recreatePageFromBlueprint((AbstractPage)page, blueprintPage, true, null);
    }

    protected void updatePageWithPageId(AbstractPage abstractPage, String storageFormat) throws Exception {
        if (this.getFieldSwapper().needsSubstitution(storageFormat, "PAGE ID")) {
            FieldValue fieldValue = new FieldValue("PAGE ID", BlueprintFieldType.MEDIUM, (Object)abstractPage.getIdAsString());
            storageFormat = this.getFieldSwapper().applyData(storageFormat, "PAGE ID", fieldValue);
            Confluence.savePageWithoutPermissionCheck((AbstractPage)abstractPage, (String)storageFormat, (String)"Add page ID after page created.", (boolean)false);
        }
    }
}

