/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.blueprintmaker.model.SpaceDefinition;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SpaceDefinitionSettings {
    public static final String SPACE_DEFINITIONS_FILENAME = "space-definitions.json";
    protected static final String SPACE_DEFINITIONS_KEY = "spaceDefinitions";
    protected static final String NAME_KEY = "name";
    protected static final String SPACE_KEY_KEY = "key";
    protected static final String SPACE_TEMPLATE_KEY = "spaceTemplate";
    protected static final String DESCRIPTION_KEY = "description";
    protected static Map<String, SpaceDefinition> spaceDefinitions;

    public static SpaceDefinition getSpaceDefinition(Space aSpace) {
        return aSpace == null ? null : SpaceDefinitionSettings.getSpaceDefinitions().get(aSpace.getKey());
    }

    public static synchronized Map<String, SpaceDefinition> getSpaceDefinitions() {
        if (spaceDefinitions == null) {
            try {
                spaceDefinitions = SpaceDefinitionSettings.readSpaceTemplatesFromFile(SpaceDefinitionSettings.getSpaceDefinitionsFile());
            }
            catch (Exception ex) {
                if (SpaceDefinitionSettings.getSpaceDefinitionsFile().exists()) {
                    BrikitLog.logDebug((String)"Failed to read space-definitions.json", (Exception)ex);
                }
                spaceDefinitions = new HashMap<String, SpaceDefinition>();
            }
        }
        return spaceDefinitions;
    }

    public static File getSpaceDefinitionsFile() {
        return BrikitFile.getBrikitFile((String)SPACE_DEFINITIONS_FILENAME);
    }

    protected static Map<String, SpaceDefinition> readSpaceTemplatesFromFile(File aFile) throws Exception {
        String fileContents = BrikitFile.readFile((File)aFile);
        return SpaceDefinitionSettings.unpackSpaceDefinitions(fileContents);
    }

    public static void reset() {
        spaceDefinitions = null;
    }

    protected static Map<String, SpaceDefinition> unpackSpaceDefinitions(String json) throws Exception {
        JSONObject jsonObject = new JSONObject(json);
        JSONArray spaceDefinitionsJSON = jsonObject.getJSONArray(SPACE_DEFINITIONS_KEY);
        HashMap<String, SpaceDefinition> definitions = new HashMap<String, SpaceDefinition>();
        for (JSONObject spaceDefinitionJSON : spaceDefinitionsJSON.objects()) {
            String name = spaceDefinitionJSON.getString(NAME_KEY);
            String key = spaceDefinitionJSON.getString(SPACE_KEY_KEY);
            String description = spaceDefinitionJSON.getString(DESCRIPTION_KEY);
            String category = spaceDefinitionJSON.getString(SPACE_TEMPLATE_KEY);
            definitions.put(key, new SpaceDefinition(name, key, description, category));
        }
        return definitions;
    }

    public static synchronized void uploadSettings(File uploadedFile) throws Exception {
        SpaceDefinitionSettings.readSpaceTemplatesFromFile(uploadedFile);
        uploadedFile.renameTo(SpaceDefinitionSettings.getSpaceDefinitionsFile());
        SpaceDefinitionSettings.reset();
    }
}

