(function ($) {
	BlueprintMaker.SpaceDefinitions = {

	 	toggleHelpPanel: function () {
			var $helpPanel = $("#space-definition-settings-help");
			$(this).toggleAttr("aria-pressed", "true");
			$helpPanel.slideToggle();
			
	 	},
		
		upload: function (event) {

			var $uploadForm = $("#upload-settings-form");
			var $inputField = $uploadForm.find("#uploadsettings");

			// Clear out then trigger the hidden file upload form
			$inputField.val("").click();

			// When the upload filename changes, automagically upload the file and invoke the import action...
			$inputField.unbind().change(function () { 
				// ...on File selection, confirm before importing
				var fileName = $inputField.val().split('\\').pop();
				return BlueprintMaker.Dialog2.doubleConfirm("<p>" + BlueprintMaker.getText("com.brikit.blueprintmaker.import.space.definitions.question", [fileName]) + "</p>", 
				  { title: BlueprintMaker.getText("com.brikit.blueprintmaker.import.space.definitions.confirm"), 
					  size: "medium", 
					  okButton: BlueprintMaker.getText("com.brikit.blueprintmaker.import.space.definitions.confirm") 
				  }, function (dialog) {
					dialog.hide();
					$uploadForm.submit();
				});
			});
		
			// Convert file upload to ajax submission (using the jquery.form plugin)
			// On submission of the file upload, check server response for errors
			$uploadForm.ajaxForm(function (result) {
				if ($(result).hasClass("errorMessage")) {
					BlueprintMaker.Dialog2.alert(result, { title: BlueprintMaker.getText("com.brikit.blueprintmaker.file.upload.error") }, BlueprintMaker.reloadBrowser);
				}
				else {
					BlueprintMaker.Dialog2.alert(
						"<p>" + BlueprintMaker.getText("com.brikit.blueprintmaker.reloading") + "</p>",
						{ title: BlueprintMaker.getText("com.brikit.blueprintmaker.success") }
					);
					BlueprintMaker.reloadBrowser(1000);
				}
			});

			return false;
		}
				
	};

})(jQuery);

BlueprintMaker.toInit(function ($) {
	$("#space-definition-settings-toolbar-help").click(BlueprintMaker.SpaceDefinitions.toggleHelpPanel);
	$("#upload-settings").click(BlueprintMaker.SpaceDefinitions.upload);
});
