/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.rest;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BlueprintBean {
    protected static final String BLUEPRINT_KEY = "blueprint";
    protected static final String NAME_KEY = "name";
    protected static final String SOURCE_KEY = "source";
    protected static final String DESTINATION_KEY = "destination";
    protected static final String DESTINATION_PAGE_ID_KEY = "pageId";
    protected static final String SPACE_KEY_KEY = "spaceKey";
    protected static final String SPACE_NAME_KEY = "spaceName";
    protected static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    protected static final String PAGE_TITLE_KEY = "pageTitle";
    protected static final String PARENT_PAGE_TITLE_ID_KEY = "parentPageTitleId";
    protected static final String PARENT_PAGE_TITLE_KEY = "parentPageTitle";
    protected static final String FIELDS_KEY = "fields";
    protected String blueprintName;
    protected String spaceKey;
    protected String spaceName;
    protected String spaceDescription;
    protected String pageTitle;
    protected String sourceSpaceKey;
    protected String sourcePageTitle;
    protected String parentPageTitle;
    protected Boolean replaceLabels;
    protected PageBlueprint pageBlueprint;
    protected SpaceBlueprint spaceBlueprint;
    protected Page destinationParentPage;
    protected AbstractPage destinationPage;
    protected Space destinationSpace;
    protected String valuesJson;
    protected List<String> pageLabels;
    protected Map<String, AttachmentResource> fileResources;

    public BlueprintBean(String jsonString) {
        try {
            JsonObject blueprint;
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse(jsonString).getAsJsonObject();
            if (json.has(BLUEPRINT_KEY) && (blueprint = json.get(BLUEPRINT_KEY).getAsJsonObject()).has(NAME_KEY)) {
                this.setBlueprintName(blueprint.get(NAME_KEY).getAsString());
            }
            if (json.has(SOURCE_KEY)) {
                JsonObject source = json.get(SOURCE_KEY).getAsJsonObject();
                if (source.has(SPACE_KEY_KEY)) {
                    this.setSourceSpaceKey(source.get(SPACE_KEY_KEY).getAsString());
                }
                if (source.has(PAGE_TITLE_KEY)) {
                    this.setSourcePageTitle(source.get(PAGE_TITLE_KEY).getAsString());
                }
            }
            if (json.has(DESTINATION_KEY)) {
                JsonObject destination = json.get(DESTINATION_KEY).getAsJsonObject();
                if (destination.has(DESTINATION_PAGE_ID_KEY)) {
                    this.setDestinationPage(destination.get(DESTINATION_PAGE_ID_KEY).getAsString());
                } else if (destination.has(SPACE_KEY_KEY)) {
                    this.setSpaceKey(destination.get(SPACE_KEY_KEY).getAsString());
                }
                if (destination.has(PAGE_TITLE_KEY)) {
                    this.setPageTitle(destination.get(PAGE_TITLE_KEY).getAsString());
                }
                if (destination.has(SPACE_NAME_KEY)) {
                    this.setSpaceName(destination.get(SPACE_NAME_KEY).getAsString());
                }
                if (destination.has(SPACE_DESCRIPTION_KEY)) {
                    this.setSpaceDescription(destination.get(SPACE_DESCRIPTION_KEY).getAsString());
                }
                if (destination.has(PARENT_PAGE_TITLE_ID_KEY)) {
                    AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)destination.get(PARENT_PAGE_TITLE_ID_KEY).getAsString());
                    if (abstractPage != null) {
                        this.setParentPageTitle(Confluence.getTitle((AbstractPage)abstractPage));
                    }
                } else if (destination.has(PARENT_PAGE_TITLE_KEY)) {
                    this.setParentPageTitle(destination.get(PARENT_PAGE_TITLE_KEY).getAsString());
                }
            }
            if (json.has(FIELDS_KEY)) {
                JsonArray values = json.get(FIELDS_KEY).getAsJsonArray();
                this.setValuesJson(values.getAsString());
            }
        }
        catch (Exception ex) {
            BrikitLog.logDebug((String)"Failed to parse parameters for Blueprint REST API", (Exception)ex);
        }
    }

    protected String getBlueprintName() {
        return this.blueprintName;
    }

    protected AbstractPage getDestinationPage() {
        if (this.destinationPage == null) {
            this.destinationPage = Confluence.getPage((String)this.getSpaceKey(), (String)this.getPageTitle());
        }
        return this.destinationPage;
    }

    protected Page getDestinationParentPage() {
        if (this.destinationParentPage == null) {
            this.destinationParentPage = BrikitString.isSet((String)this.getParentPageTitle()) ? Confluence.getPage((String)this.getSpaceKey(), (String)this.getParentPageTitle()) : Confluence.getSpaceHomePage((String)this.getSpaceKey());
        }
        return this.destinationParentPage;
    }

    protected Space getDestinationSpace() {
        if (this.destinationSpace == null) {
            this.destinationSpace = Confluence.getSpace((String)this.getSpaceKey());
        }
        return this.destinationSpace;
    }

    public Map<String, AttachmentResource> getFileResources() {
        return Collections.EMPTY_MAP;
    }

    protected PageBlueprint getPageBlueprint() {
        if (this.pageBlueprint == null) {
            this.pageBlueprint = BlueprintDefinitions.getPageBlueprint(this.getBlueprintName());
        }
        return this.pageBlueprint;
    }

    public List<String> getPageLabels() {
        return Collections.EMPTY_LIST;
    }

    protected String getPageTitle() {
        return this.pageTitle;
    }

    protected String getParentPageTitle() {
        return this.parentPageTitle;
    }

    protected Boolean getReplaceLabels() {
        return this.replaceLabels;
    }

    protected AbstractPage getSourcePage() {
        return Confluence.getPage((String)this.getSourceSpaceKey(), (String)this.getSourcePageTitle());
    }

    public String getSourcePageTitle() {
        return this.sourcePageTitle;
    }

    protected Space getSourceSpace() {
        return Confluence.getSpace((String)this.getSourceSpaceKey());
    }

    public String getSourceSpaceKey() {
        return this.sourceSpaceKey;
    }

    protected SpaceBlueprint getSpaceBlueprint() {
        if (this.spaceBlueprint == null) {
            this.spaceBlueprint = BlueprintDefinitions.getSpaceBlueprint(this.getBlueprintName());
        }
        return this.spaceBlueprint;
    }

    public String getSpaceDescription() {
        return this.spaceDescription;
    }

    protected String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getValuesJson() {
        return this.valuesJson;
    }

    protected boolean isCreating() {
        return this.getDestinationPage() == null;
    }

    protected void setBlueprintName(String blueprintName) {
        this.blueprintName = blueprintName;
    }

    public void setDestinationPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        if (abstractPage != null) {
            this.setSpaceKey(Confluence.getSpaceKey((AbstractPage)abstractPage));
            this.setPageTitle(Confluence.getTitle((AbstractPage)abstractPage));
        }
    }

    protected void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    protected void setParentPageTitle(String parentPageTitle) {
        this.parentPageTitle = parentPageTitle;
    }

    protected void setReplaceLabels(Boolean replaceLabels) {
        this.replaceLabels = replaceLabels;
    }

    public void setSourcePageTitle(String sourcePageTitle) {
        this.sourcePageTitle = sourcePageTitle;
    }

    public void setSourceSpaceKey(String sourceSpaceKey) {
        this.sourceSpaceKey = sourceSpaceKey;
    }

    public void setSpaceDescription(String spaceDescription) {
        this.spaceDescription = spaceDescription;
    }

    protected void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public void setValuesJson(String valuesJson) {
        this.valuesJson = valuesJson;
    }
}

