/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.AccessPermission;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import java.util.ArrayList;
import java.util.List;

public class CopySpaceBlueprint
extends SpaceBlueprint {
    public static final String COPY_SPACE_BLUEPRINT_NAME = "@copy-space";

    public CopySpaceBlueprint(String fromSpaceKey, String spaceName, String spaceKey, String spaceDescription) {
        super(COPY_SPACE_BLUEPRINT_NAME, null, new ArrayList<String>(), fromSpaceKey, spaceKey, spaceName, spaceDescription, new ArrayList<BlueprintField>(), CopySpaceBlueprint.getAccessList(fromSpaceKey));
    }

    public static boolean isCopySpace(String blueprintName) {
        return COPY_SPACE_BLUEPRINT_NAME.equalsIgnoreCase(blueprintName);
    }

    public static List<Access> getAccessList(String fromSpaceKey) {
        AccessPermission accessPermission;
        Space fromSpace = Confluence.getSpace((String)fromSpaceKey);
        ArrayList<AccessPermission> accessPermissions = new ArrayList<AccessPermission>();
        for (Group group : Confluence.getGroupsWithSpacePermissions((String)fromSpaceKey)) {
            accessPermission = new AccessPermission("group", group.getName(), Confluence.getExplicitSpacePermissionsForGroup((Space)fromSpace, (Group)group));
            accessPermissions.add(accessPermission);
        }
        for (User user : Confluence.getUsersWithSpacePermissions((String)fromSpaceKey)) {
            accessPermission = new AccessPermission("user", user.getName(), Confluence.getExplicitSpacePermissionsForUser((Space)fromSpace, (ConfluenceUser)Confluence.getConfluenceUser((String)user.getName())));
            accessPermissions.add(accessPermission);
        }
        List anonymousPermissions = Confluence.getExplicitSpacePermissionsForAnonymousUsers((Space)fromSpace);
        if (!anonymousPermissions.isEmpty()) {
            AccessPermission accessPermission2 = new AccessPermission("anonymous", null, anonymousPermissions);
            accessPermissions.add(accessPermission2);
        }
        Access access = new Access(COPY_SPACE_BLUEPRINT_NAME, accessPermissions);
        ArrayList<Access> accesses = new ArrayList<Access>();
        accesses.add(access);
        return accesses;
    }

    @Override
    public String getHomePageTitleBlueprint() {
        return Confluence.getText((String)"default.space.homepage.title", (Object[])new Object[]{this.getSpaceName()});
    }
}

