/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.util.LabelUtil;
import com.brikit.core.confluence.Confluence;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SpaceLabelsCache {
    protected static Cache<String, String> cache;
    protected static CacheSettings cacheSettings;

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache(Confluence.getText("Brikit Space Labels Cache"), new CacheLoader<String, String>(){

                @Override
                public String load(String spaceKey) {
                    return LabelUtil.convertToDelimitedString((List)Confluence.getSpaceLabelManager().getTeamLabelsOnSpace(spaceKey));
                }
            }, cacheSettings);
        }
        return cache;
    }

    public static String getSpaceLabels(String spaceKey) {
        return SpaceLabelsCache.getCache().get(spaceKey);
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }
}

