/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.util.GeneralUtil;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitProperties;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.WordUtils;

public class BrikitString {
    public static String camelCase(String aString) {
        if (!BrikitString.isSet(aString)) {
            return "";
        }
        String firstChar = aString.substring(0, 1);
        String camelized = BrikitString.removeWhiteSpace(BrikitString.titleize(aString));
        return firstChar + camelized.substring(1);
    }

    public static String capitalizeFirstLetter(String string) {
        return string == null ? string : WordUtils.capitalize((String)string);
    }

    public static String chunk(String aString, int n) {
        StringBuilder builder = new StringBuilder();
        while (aString.length() > n) {
            builder.append(aString.substring(0, n));
            builder.append("\n");
            aString = aString.substring(n);
        }
        builder.append(aString);
        return builder.toString();
    }

    public static String classify(String string) {
        return string == null ? string : BrikitString.humanize(string).replaceAll("\\s+", "-").toLowerCase();
    }

    public static String cleanWhitespace(String aString) {
        aString = aString.trim().replaceAll("\\s+", " ");
        StringBuffer buffer = new StringBuffer(aString.length());
        StringCharacterIterator it = new StringCharacterIterator(aString);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"' | c == '\'') {
                buffer.append('\\');
            }
            buffer.append(c);
            c = it.next();
        }
        return buffer.toString();
    }

    public static String decodeSpecialCharacters(String aString) {
        return aString.replaceAll("&amp;", "&");
    }

    public static String decodeURL(String aString) {
        return GeneralUtil.shouldUrlDecode((String)aString) ? GeneralUtil.urlDecode((String)aString) : aString;
    }

    public static String ensureOuterParagraph(String aString, boolean wantsParagraph) {
        String trimmed = aString.trim().replaceAll("<[pP]>(.*)</[pP]>", "$1");
        return wantsParagraph ? "<p>" + trimmed + "</p>" : trimmed;
    }

    public static String ensureStartsWith(String aString, String prefix) {
        return aString.startsWith(prefix) ? aString : prefix + aString;
    }

    public static boolean equal(String string1, String string2) {
        return string1 == null ? string2 == null : string1.equals(string2);
    }

    public static String formatProperties(Properties aProperties) {
        StringBuilder builder = new StringBuilder();
        for (Object key : aProperties.keySet()) {
            builder.append(key);
            builder.append("=");
            builder.append(aProperties.get(key));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String fromBytes(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static BrikitProperties getProperties(String propertiesString) {
        BrikitProperties properties = new BrikitProperties();
        for (String line : BrikitString.split(propertiesString, "\n")) {
            int spot = line.indexOf("=");
            if (spot == -1) continue;
            properties.put(line.substring(0, spot), line.substring(spot + 1));
        }
        return properties;
    }

    public static String decamelize(String string) {
        if (string == null) {
            return string;
        }
        Pattern pattern = Pattern.compile("([^A-Z])([A-Z])");
        Matcher matcher = pattern.matcher(string);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "$1 $2");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String humanize(String string) {
        return string == null ? string : BrikitString.decamelize(string).replaceAll("-", " ").replaceAll("_", " ");
    }

    public static InputStream inputStream(String string) {
        return new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")));
    }

    public static boolean isSet(String aString) {
        return aString != null && TextUtils.stringSet((String)aString.trim());
    }

    public static String join(String a, String b) {
        BrikitList<String> list = new BrikitList<String>();
        list.add(a);
        list.add(b);
        return list.join();
    }

    public static boolean matchesAnyPattern(Object aString, List<String> patterns) {
        if (!(aString instanceof String)) {
            return false;
        }
        for (String pattern : patterns) {
            if (!(pattern.endsWith("*") ? ((String)aString).startsWith(pattern = pattern.substring(0, pattern.length() - 1)) : aString.equals(pattern))) continue;
            return true;
        }
        return true;
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String removeOuterParagraph(String aString) {
        return aString.trim().replaceAll("<[pP]>(.*)</[pP]>", "$1");
    }

    public static String removeTags(String aString) {
        return aString.replaceAll("<[A-Za-z/^>]+>", "");
    }

    public static String removeWhiteSpace(String aString) {
        return aString == null ? "" : aString.replaceAll("\\s", "");
    }

    public static List<String> sortSplit(String string, String separator) {
        BrikitList<String> items = BrikitString.split(string, separator);
        Collections.sort(items, String.CASE_INSENSITIVE_ORDER);
        return items;
    }

    public static BrikitList<String> split(String string) {
        return BrikitString.split(string, "\\s+");
    }

    public static BrikitList<String> split(String string, String separator) {
        BrikitList<String> list = new BrikitList<String>();
        if (!TextUtils.stringSet((String)string)) {
            return list;
        }
        for (String element : string.trim().split(separator)) {
            if (!BrikitString.isSet(element)) continue;
            list.add(BrikitString.unescape(element.trim()));
        }
        return list;
    }

    public static BrikitList<String> splitOnFirst(String string, String separator) {
        BrikitList<String> list = new BrikitList<String>();
        if (!BrikitString.isSet(string)) {
            return list;
        }
        int spot = string.indexOf(separator);
        if (spot == -1) {
            list.add(BrikitString.unescape(string.trim()));
        } else {
            list.add(BrikitString.unescape(string.substring(0, spot).trim()));
            list.add(BrikitString.unescape(string.substring(spot + separator.length()).trim()));
        }
        return list;
    }

    public static BrikitList<String> splitCommaSeparated(String string) {
        return BrikitString.split(string, "\\s*,\\s*");
    }

    public static BrikitList<String> splitCommaOrSpaceSeparated(String string) {
        return BrikitString.split(string, "[\\s,]+");
    }

    public static String titleize(String string) {
        char[] delimiters = new char[]{' ', '-'};
        return string == null ? string : WordUtils.capitalizeFully((String)BrikitString.decamelize(string), (char[])delimiters);
    }

    public static byte[] toBytes(String string) {
        return Base64.decodeBase64((byte[])string.getBytes());
    }

    public static String tokenize(String string) {
        return string == null ? string : BrikitString.humanize(string).toLowerCase().replaceAll("\\s+", "_").replaceAll("[^a-z^0-9^_]", "");
    }

    public static String trimToNull(String string) {
        return BrikitString.isSet(string) ? string.trim() : null;
    }

    public static String trimToString(String string) {
        return BrikitString.isSet(string) ? string.trim() : "";
    }

    public static String truncate(String string, int length) {
        return BrikitString.truncate(string, length, true);
    }

    public static String truncate(String string, int length, boolean addElipsis) {
        return BrikitString.isSet(string) && string.length() > length ? string.substring(0, length) + (addElipsis ? "..." : "") : string;
    }

    public static String unescape(String aString) {
        return GeneralUtil.unescapeEntities((String)aString);
    }

    public static String i18nSafe(String key) {
        return BrikitString.removeTags(Confluence.getText(key));
    }
}

