/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.brikit.core.util.BrikitMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BrikitOrderedMap<K, V>
extends BrikitMap<K, V> {
    List<K> keysInOrder = new ArrayList<K>();

    public BrikitOrderedMap() {
    }

    public BrikitOrderedMap(Map<K, V> aMap) {
        super(aMap == null ? new HashMap() : aMap);
        this.addKeysToOrderedList(this);
    }

    private synchronized void addKeyToOrderedList(K key) {
        this.keysInOrder.add(key);
    }

    private synchronized void addKeysToOrderedList(Map<K, V> aMap) {
        this.keysInOrder.addAll(aMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        BrikitOrderedMap brikitOrderedMap = this;
        synchronized (brikitOrderedMap) {
            this.keysInOrder = new ArrayList<K>();
        }
        super.clear();
    }

    public synchronized List<K> getKeysInOrder() {
        return new ArrayList<K>(this.keysInOrder);
    }

    @Override
    public V put(K key, V value) {
        this.addKeyToOrderedList(key);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> aMap) {
        this.addKeysToOrderedList(aMap);
        super.putAll(aMap);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.keysInOrder.contains(key)) {
            this.addKeyToOrderedList(key);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public V remove(Object key) {
        this.removeKeyFromOrderedList(key);
        return super.remove(key);
    }

    private synchronized void removeKeyFromOrderedList(K key) {
        this.keysInOrder.remove(key);
    }

    private synchronized void removeKeysFromOrderedList(Map<K, V> aMap) {
        this.keysInOrder.removeAll(aMap.keySet());
    }
}

