/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.search;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.List;

public class PagingCQLSearcher {
    protected String spaceKey;
    protected long pageId;
    protected int nextResult;
    protected PageResponse<Content> response;

    public PagingCQLSearcher() {
    }

    public PagingCQLSearcher(String contextSpaceKey) {
        this(contextSpaceKey, null);
    }

    public PagingCQLSearcher(String contextSpaceKey, long contextPageId) {
        this.setSpaceContext(contextSpaceKey);
        this.setPageContext(contextPageId);
    }

    public PagingCQLSearcher(String contextSpaceKey, AbstractPage contextPage) {
        this.setSpaceContext(contextSpaceKey);
        if (contextPage != null) {
            this.setPageContext(contextPage.getId());
        }
    }

    public List<ContentEntityObject> convertResults() {
        ArrayList<ContentEntityObject> results = new ArrayList<ContentEntityObject>();
        for (Content result : this.getResponse().getResults()) {
            ContentEntityObject ceo = Confluence.getContentEntity(result.getId().asLong());
            if (ceo == null) continue;
            results.add(ceo);
        }
        return results;
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public int getNextResult() {
        return this.nextResult;
    }

    public long getPageId() {
        return this.pageId;
    }

    protected PageResponse<Content> getResponse() {
        return this.response;
    }

    protected SearchContext getSearchContext() {
        SearchContext.Builder contextBuilder = SearchContext.builder();
        if (BrikitString.isSet(this.getSpaceKey())) {
            contextBuilder.spaceKey(this.getSpaceKey());
        }
        if (this.getAbstractPage() != null) {
            contextBuilder.contentId(this.getAbstractPage().getContentId());
        }
        return contextBuilder.build();
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public boolean hasMore() {
        return this.getResponse().hasMore();
    }

    public PageResponse<Content> search(String cql, int start, int count) {
        if (!BrikitString.isSet(cql)) {
            cql = "created < \"2000/01/01\"";
        }
        SimplePageRequest pageRequest = new SimplePageRequest(start, count);
        this.setResponse((PageResponse<Content>)Confluence.getSearchService().searchContent(cql, this.getSearchContext(), (PageRequest)pageRequest, new Expansion[0]));
        this.setNextResult(this.response.hasMore() ? start + count : -1);
        return this.getResponse();
    }

    public PageResponse<Content> search(String cql, int start, int count, String contextSpaceKey, long contextPageId) {
        this.setSpaceContext(contextSpaceKey);
        this.setPageContext(contextPageId);
        return this.search(cql, start, count);
    }

    protected void setNextResult(int nextResult) {
        this.nextResult = nextResult;
    }

    public void setPageContext(long pageId) {
        this.pageId = pageId;
    }

    protected void setResponse(PageResponse<Content> response) {
        this.response = response;
    }

    public void setSpaceContext(String spaceKey) {
        this.spaceKey = spaceKey;
    }
}

