/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.theme;

import com.atlassian.confluence.plugin.descriptor.ThemeModuleDescriptor;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.BrikitDeveloperSettingsListener;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.develop.ExternalDevelopmentModeSettings;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServlet;
import org.apache.commons.collections.EnumerationUtils;

public class ThemeResourceServlet
extends HttpServlet {
    public static final String THEME_KEY = "com.brikit.themepress:theme-base";
    public static final String THEME_MODULE_KEY = "theme-base";
    protected static final String THEME_RESOURCE_DESCRIPTOR_TAG = "theme-press/";
    protected static final String BUILT_IN_THEMES_RESOURCE_DESCRIPTOR_TAG = "themes/";
    protected static final String RENDER_SERVLET_PATH = "/plugins/servlet/themepress";
    protected static String parseFileLocation;

    public static String directURL() {
        return ExternalDevelopmentMode.directURL(THEME_KEY);
    }

    protected static String externalFileLocation() {
        return ExternalDevelopmentMode.isDeveloperMode() ? ExternalDevelopmentMode.externalFileLocation() : ThemeResourceServlet.getEmbeddedFileLocation(THEME_KEY);
    }

    protected static String getEmbeddedDirectURL(String aThemeKey) {
        return Confluence.getContextPath() + "/download/resources/" + aThemeKey + "/theme-press";
    }

    protected static String getEmbeddedFileLocation(String moduleKey) {
        String embeddedResourceDirectory = ThemeResourceServlet.getThemeResourceDescriptorLocation(moduleKey);
        if (embeddedResourceDirectory.endsWith("/") || embeddedResourceDirectory.endsWith("\\")) {
            embeddedResourceDirectory = embeddedResourceDirectory.substring(0, Math.max(0, embeddedResourceDirectory.length() - 1));
        }
        return embeddedResourceDirectory;
    }

    private static String getParseFileLocation() {
        return parseFileLocation;
    }

    public static String getPluginResource(String aFilename) {
        String location = ThemeResourceServlet.getEmbeddedFileLocation(THEME_KEY);
        return aFilename == null ? location : location + "/" + aFilename;
    }

    public static String getServerFileLocation(String aFilename) {
        String location = ThemeResourceServlet.externalFileLocation();
        return aFilename == null ? location : location + "/" + aFilename;
    }

    protected static ThemeModuleDescriptor getThemeDescriptor(String aThemeKey) {
        for (ThemeModuleDescriptor descriptor : Confluence.getThemeManager().getAvailableThemeDescriptors()) {
            if (!descriptor.getCompleteKey().equals(aThemeKey)) continue;
            return descriptor;
        }
        return null;
    }

    protected static ResourceDescriptor getThemeResourceDescriptor(String aThemeKey) {
        return ThemeResourceServlet.getThemeResourceDescriptor(aThemeKey, THEME_RESOURCE_DESCRIPTOR_TAG);
    }

    protected static ResourceDescriptor getThemeResourceDescriptor(String aThemeKey, String resourceName) {
        ThemeModuleDescriptor themeDescriptor = ThemeResourceServlet.getThemeDescriptor(aThemeKey);
        if (themeDescriptor == null) {
            return null;
        }
        for (ResourceDescriptor resourceDescriptor : themeDescriptor.getResourceDescriptors()) {
            if (!resourceDescriptor.getName().equals(resourceName)) continue;
            return resourceDescriptor;
        }
        return null;
    }

    protected static String getThemeResourceDescriptorLocation(String moduleKey) {
        if (!THEME_KEY.equals(moduleKey)) {
            return moduleKey;
        }
        ResourceDescriptor resourceDescriptor = ThemeResourceServlet.getThemeResourceDescriptor(moduleKey);
        if (resourceDescriptor == null) {
            return "";
        }
        return resourceDescriptor.getLocation();
    }

    protected static String getThemeResourceLocation() {
        ResourceDescriptor resourceDescriptor = ThemeResourceServlet.getThemeResourceDescriptor(THEME_KEY, BUILT_IN_THEMES_RESOURCE_DESCRIPTOR_TAG);
        return resourceDescriptor == null ? "" : resourceDescriptor.getLocation();
    }

    public static Plugin getZenPlugin() {
        return ThemeResourceServlet.getThemeDescriptor(THEME_KEY).getPlugin();
    }

    public static Date getZenPluginLoaded() {
        return ThemeResourceServlet.getZenPlugin().getDateLoaded();
    }

    public static String parseFileLocation(String moduleKey) {
        parseFileLocation = null;
        if (parseFileLocation == null) {
            parseFileLocation = ExternalDevelopmentMode.isDeveloperMode() ? ExternalDevelopmentMode.confluenceInstallFileLocation(moduleKey) : ThemeResourceServlet.getEmbeddedFileLocation(moduleKey);
        }
        return parseFileLocation;
    }

    public static String renderURL() {
        return Confluence.getContextPath() + RENDER_SERVLET_PATH;
    }

    public static InputStream themeResource(String aFilename) throws FileNotFoundException {
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            return new FileInputStream(new File(ThemeResourceServlet.getServerFileLocation(aFilename)));
        }
        return ClassLoaderUtils.getResourceAsStream((String)(ThemeResourceServlet.getParseFileLocation() + "/" + aFilename), ThemeResourceServlet.class);
    }

    public static InputStream themeResourceFromJar(String aFilename) throws FileNotFoundException {
        return ClassLoaderUtils.getResourceAsStream((String)(ThemeResourceServlet.getThemeResourceLocation() + "/" + aFilename), ThemeResourceServlet.class);
    }

    public static String themeResourceTextContents(String aFilename) {
        try {
            return BrikitFile.readInputStream(ThemeResourceServlet.themeResource(aFilename));
        }
        catch (IOException ex) {
            BrikitLog.logError("Failed to read theme resource file: " + aFilename, ex);
            return "";
        }
    }

    public static List themeResources(String aLocation) throws IOException {
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            File dir = new File(ThemeResourceServlet.getServerFileLocation(aLocation));
            return dir.isDirectory() ? Arrays.asList(dir.listFiles()) : new ArrayList();
        }
        Enumeration resources = ClassLoaderUtils.getResources((String)(ThemeResourceServlet.getParseFileLocation() + "/" + aLocation), ThemeResourceServlet.class);
        return EnumerationUtils.toList((Enumeration)resources);
    }

    static {
        ExternalDevelopmentModeSettings.addListener(new BrikitDeveloperSettingsListener(){

            @Override
            public void externalDevelopmentModeSettingsChanged() {
                parseFileLocation = null;
            }
        });
    }
}

