/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.rest;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.brikit.blueprintmaker.model.BlueprintPage;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.blueprintmaker.rest.AbstractBlueprintResource;
import com.brikit.blueprintmaker.rest.BlueprintBean;
import com.brikit.blueprintmaker.rest.BlueprintResourceModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
public class BlueprintResource
extends AbstractBlueprintResource {
    protected final BlueprintManager blueprintManager;
    protected final ContentBlueprintManager contentBlueprintManager;
    protected final TransactionTemplate transactionTemplate;

    public BlueprintResource(@ComponentImport BlueprintManager blueprintManager, @ComponentImport ContentBlueprintManager contentBlueprintManager, @ConfluenceImport TransactionTemplate transactionTemplate) {
        this.blueprintManager = blueprintManager;
        this.contentBlueprintManager = contentBlueprintManager;
        this.transactionTemplate = transactionTemplate;
    }

    @PUT
    @Path(value="/copypage")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response copyPage(final String jsonString) {
        return (Response)this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                BlueprintBean bean = new BlueprintBean(jsonString);
                if (BlueprintResource.this.noSourcePageFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Page to copy not found.");
                }
                if (BlueprintResource.this.noCreatePagePermissions(bean.getSpaceKey())) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "You don't have permission to create pages in the specified space.");
                }
                if (BlueprintResource.this.noDestinationSpaceFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Destination space not found.");
                }
                if (!BlueprintResource.this.noDestinationPageFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "Destination page already exists.");
                }
                Page parent = BlueprintResource.this.noDestinationParentPageFound(bean) ? Confluence.getParent((Page)bean.getSourcePage()) : bean.getDestinationParentPage();
                try {
                    AbstractPage abstractPage = BlueprintPage.copyPage(bean.getSourcePage(), bean.getSpaceKey(), bean.getPageTitle(), parent);
                    return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
                }
                catch (Exception ex) {
                    BrikitLog.logError("Copy page via Blueprint Maker REST API failed", ex);
                    return BlueprintResource.this.responseException("Copy page not successful.", ex);
                }
            }
        });
    }

    @PUT
    @Path(value="/copyspace")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response copySpace(final String jsonString) {
        return (Response)this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                BlueprintBean bean = new BlueprintBean(jsonString);
                if (BlueprintResource.this.noSourceSpaceFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Space to copy not found.");
                }
                if (BlueprintResource.this.noCreateSpacePermissions()) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "You don't have permission to create spaces.");
                }
                if (!BlueprintResource.this.noDestinationSpaceFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "Destination space already exists.");
                }
                try {
                    Space newSpace = SpaceBlueprint.createFromSpaceBlueprint("@copy-space", bean.getSourceSpaceKey(), bean.getSpaceName(), bean.getSpaceKey(), bean.getSpaceDescription(), bean.getValuesJson(), bean.getFileResources(), BlueprintResource.this.getBlueprintManager(), BlueprintResource.this.getContentBlueprintManager());
                    Page abstractPage = Confluence.getSpaceHomePage(newSpace);
                    return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
                }
                catch (Exception ex) {
                    BrikitLog.logError("Copy space via Blueprint Maker REST API failed", ex);
                    return BlueprintResource.this.responseException("Copy space not successful.", ex);
                }
            }
        });
    }

    @PUT
    @Path(value="/createpage")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response createPage(final String jsonString) {
        return (Response)this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                BlueprintBean bean = new BlueprintBean(jsonString);
                if (BlueprintResource.this.noPageBlueprintFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Blueprint not found.");
                }
                if (BlueprintResource.this.noCreatePagePermissions(bean.getSpaceKey())) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "You don't have permission to create pages in the specified space.");
                }
                if (BlueprintResource.this.noDestinationSpaceFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Destination space not found.");
                }
                if (!BlueprintResource.this.noDestinationPageFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "Destination page already exists.");
                }
                try {
                    AbstractPage abstractPage = BlueprintPage.createFromPageBlueprint(bean.getBlueprintName(), bean.getSpaceKey(), bean.getPageTitle(), bean.getDestinationParentPage(), bean.getValuesJson(), bean.getFileResources(), bean.getPageLabels());
                    return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
                }
                catch (Exception ex) {
                    BrikitLog.logError("Create page via Blueprint Maker REST API failed", ex);
                    return BlueprintResource.this.responseException("Create page not successful.", ex);
                }
            }
        });
    }

    @PUT
    @Path(value="/createspace")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response createSpace(final String jsonString) {
        return (Response)this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                BlueprintBean bean = new BlueprintBean(jsonString);
                if (BlueprintResource.this.noCreateSpacePermissions()) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "You don't have permission to create spaces.");
                }
                if (!BlueprintResource.this.noDestinationSpaceFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.FORBIDDEN, "Destination space already exists.");
                }
                try {
                    Space newSpace = SpaceBlueprint.createFromSpaceBlueprint(bean.getBlueprintName(), bean.getSourceSpaceKey(), bean.getSpaceName(), bean.getSpaceKey(), bean.getSpaceDescription(), bean.getValuesJson(), bean.getFileResources(), BlueprintResource.this.getBlueprintManager(), BlueprintResource.this.getContentBlueprintManager());
                    Page abstractPage = Confluence.getSpaceHomePage(newSpace);
                    return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
                }
                catch (Exception ex) {
                    BrikitLog.logError("Create space via Blueprint Maker REST API failed", ex);
                    return BlueprintResource.this.responseException("Create space not successful.", ex);
                }
            }
        });
    }

    public BlueprintManager getBlueprintManager() {
        return this.blueprintManager;
    }

    public ContentBlueprintManager getContentBlueprintManager() {
        return this.contentBlueprintManager;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @POST
    @Path(value="/updatepage/{pageid}")
    @Produces(value={"application/json", "application/xml"})
    public Response updatePage(final @PathParam(value="pageid") String pageId, final String jsonString) {
        return (Response)this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                BlueprintBean bean = new BlueprintBean(jsonString);
                String newPageTitle = bean.getPageTitle();
                bean.setDestinationPage(pageId);
                if (BlueprintResource.this.noPageBlueprintFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Blueprint not found.");
                }
                if (BlueprintResource.this.noDestinationPageFound(bean)) {
                    return BlueprintResource.this.response(Response.Status.NOT_FOUND, "Destination page not found.");
                }
                try {
                    AbstractPage abstractPage = BlueprintPage.regeneratePageFromBlueprint(bean.getBlueprintName(), pageId, newPageTitle, bean.getValuesJson(), bean.getFileResources(), bean.getPageLabels());
                    return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
                }
                catch (Exception ex) {
                    BrikitLog.logError("Update page via Blueprint Maker REST API failed", ex);
                    return BlueprintResource.this.responseException("Update page not successful.", ex);
                }
            }
        });
    }
}

