/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.user.User;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;

public class BrikitFile {
    protected static final String BRIKIT_HOME_FOLDER = "brikit";

    public static void allowUserToDownload(File file) throws IOException {
        Confluence.getGateKeeper().addKey(BrikitFile.prepareDownloadPath(file.getPath()), (User)Confluence.getConfluenceUser());
    }

    public static void copy(File sourceFile, File newFile) throws FileNotFoundException, IOException {
        if (!sourceFile.exists()) {
            return;
        }
        if (sourceFile.isDirectory()) {
            BrikitFile.ensurePathExists(newFile);
            for (File file : sourceFile.listFiles((FilenameFilter)HiddenFileFilter.VISIBLE)) {
                BrikitFile.copy(file, new File(newFile, file.getName()));
            }
        } else {
            BrikitFile.writeInputStream(new BufferedInputStream(new FileInputStream(sourceFile)), newFile);
        }
    }

    public static File getAndEnsureBrikitDirectoryExists(String aName) throws IOException {
        return BrikitFile.getAndEnsureDirectoryExists(BrikitFile.getBrikitHomeFolder(), aName);
    }

    public static File getAndEnsureDirectoryExists(File rootDirectory, String directory) throws IOException {
        File location = new File(rootDirectory, directory);
        BrikitFile.ensurePathExists(location);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensurePathExists(File directory) throws IOException {
        String string = directory.getAbsolutePath();
        synchronized (string) {
            directory.mkdirs();
        }
    }

    public static void ensurePathExists(String directory) throws IOException {
        BrikitFile.ensurePathExists(new File(directory));
    }

    public static String fileExtension(File file) {
        return BrikitFile.fileExtension(file.getName());
    }

    public static String fileExtension(String filename) {
        int i = filename.lastIndexOf(".");
        return i == -1 ? "" : filename.substring(i + 1);
    }

    public static String fileWithExtension(File file, String extension) {
        return BrikitFile.fileWithExtension(file.getName(), extension);
    }

    public static String fileWithExtension(String filename, String extension) {
        String filenameRoot = BrikitFile.nameWithoutExtension(filename);
        return filenameRoot + "." + extension;
    }

    public static File getBrikitHomeFolder() {
        File homeFolder = new File(Confluence.getConfluenceHome(), BRIKIT_HOME_FOLDER);
        try {
            BrikitFile.ensurePathExists(homeFolder);
        }
        catch (IOException e) {
            BrikitLog.logError("Unable to create Brikit Theme Press configuration directory: " + homeFolder, e);
        }
        return homeFolder;
    }

    public static File getBrikitFile(String aName) {
        return new File(BrikitFile.getBrikitHomeFolder(), aName);
    }

    public static long getCheckSum(File aFile) throws IOException {
        CRC32 checksum = new CRC32();
        checksum.update(BrikitFile.readBytes(aFile));
        return checksum.getValue();
    }

    public static String getConfluenceTempDirectoryPath() {
        return Confluence.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir");
    }

    public static File getConfluenceTempDirectoryPath(String filename) {
        return new File(BrikitFile.getConfluenceTempDirectoryPath(), filename);
    }

    public static InputStream inputStreamUTF8(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
        return IOUtils.toInputStream((String)IOUtils.toString((Reader)reader), (Charset)StandardCharsets.UTF_8);
    }

    public static boolean isImage(File file) {
        return BrikitFile.isImage(file.getName());
    }

    public static boolean isImage(String filename) {
        if (!BrikitString.isSet(filename)) {
            return false;
        }
        return (filename = filename.toLowerCase()).endsWith(".png") || filename.endsWith(".gif") || filename.endsWith(".jpg") || filename.endsWith(".jpeg");
    }

    public static boolean isVideo(String filename) {
        if (!BrikitString.isSet(filename)) {
            return false;
        }
        return (filename = filename.toLowerCase()).endsWith(".mp4") || filename.endsWith(".webm") || filename.endsWith(".ogg");
    }

    public static BrikitList<String> namesFromFiles(List<File> files) {
        BrikitList<String> names = new BrikitList<String>(files.size());
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }

    public static String nameWithoutExtension(File file) {
        return BrikitFile.nameWithoutExtension(file.getName());
    }

    public static String nameWithoutExtension(String filename) {
        int i = filename.lastIndexOf(".");
        return i == -1 ? filename : filename.substring(0, i);
    }

    public static String prepareDownloadPath(String path) throws IOException {
        if (Confluence.isConfluenceVersionAtLeast("7.19")) {
            String canonicalPath = new File(path).getCanonicalPath();
            int exportDirIndex = canonicalPath.indexOf(BrikitFile.getConfluenceTempDirectoryPath());
            if (exportDirIndex != -1) {
                path = canonicalPath.substring(exportDirIndex + BrikitFile.getConfluenceTempDirectoryPath().length());
            }
            return "/download/export" + path.replaceAll("\\\\", "/");
        }
        String homeDir = Confluence.getConfluenceHomeDirectory().getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        if (homeDirIndex != -1) {
            path = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        }
        return "/download/" + path.replaceAll("\\\\", "/");
    }

    public static String readBuffer(BufferedReader reader) throws IOException {
        StringBuffer readBuffer = new StringBuffer();
        String readLine = null;
        try {
            while ((readLine = reader.readLine()) != null) {
                readBuffer.append(readLine + "\n");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            reader.close();
        }
        return readBuffer.toString();
    }

    public static byte[] readBytes(File aFile) throws IOException {
        if (aFile == null) {
            throw new IOException("No file to read.");
        }
        return IOUtils.toByteArray((InputStream)new FileInputStream(aFile));
    }

    public static String readFile(File aFile) throws IOException {
        return aFile.exists() ? BrikitFile.readBuffer(new BufferedReader(new FileReader(aFile))) : "";
    }

    public static String readFile(String aFilePath) throws IOException {
        return BrikitFile.readFile(new File(aFilePath));
    }

    public static String readFileUTF8(File aFile) throws IOException {
        return aFile.exists() ? BrikitFile.readBuffer(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF8"))) : "";
    }

    public static String readFileUTF8(String aFilePath) throws IOException {
        return BrikitFile.readFileUTF8(new File(aFilePath));
    }

    public static BrikitList<String> readFileUTF8Lines(File aFile) throws IOException {
        return aFile.exists() ? BrikitFile.readInputStreamUTF8Lines(new FileInputStream(aFile)) : new BrikitList<String>();
    }

    public static BrikitList<String> readInputStreamUTF8Lines(InputStream inputStream) throws IOException {
        BrikitList<String> lines = new BrikitList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));){
            String str;
            while ((str = reader.readLine()) != null) {
                lines.add(str);
            }
        }
        return lines;
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        return BrikitFile.readBuffer(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public static String readInputStreamUTF8(InputStream inputStream) throws IOException {
        return BrikitFile.readBuffer(new BufferedReader(new InputStreamReader(inputStream, "UTF8")));
    }

    public static Properties readProperties(File aFile) {
        try {
            return BrikitFile.readProperties(new FileInputStream(aFile));
        }
        catch (FileNotFoundException e) {
            return new Properties();
        }
    }

    public static Properties readProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (Exception ex) {
            BrikitLog.logError("Failed to read properties input stream.", ex);
        }
        return properties;
    }

    public static void removeFile(File aFile) {
        if (aFile.getName().equals(".") || aFile.getName().equals("..")) {
            return;
        }
        if (aFile.isDirectory()) {
            for (File file : aFile.listFiles()) {
                BrikitFile.removeFile(file);
            }
        }
        aFile.delete();
    }

    public static String separator() {
        return System.getProperty("file.separator");
    }

    public static void write(String data, File outputFile) throws IOException {
        BrikitFile.write(data, outputFile, false);
    }

    public static void write(String data, File outputFile, boolean append) throws IOException {
        FileWriter writer = new FileWriter(outputFile, append);
        writer.write(data);
        writer.flush();
        writer.close();
    }

    public static void writeFileUTF8(String data, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        writer.write(data);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static void writeFileUTF8Lines(List<String> lines, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF8"));
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    public static void writeInputStream(InputStream inputStream, File outputFile) throws IOException {
        BrikitFile.writeInputStream(inputStream, outputFile, false);
    }

    public static void writeInputStream(InputStream inputStream, File outputFile, boolean append) throws IOException {
        int size;
        if (inputStream == null) {
            throw new IOException("No input stream provided to write to file: " + outputFile.getPath());
        }
        FileOutputStream outputStream = new FileOutputStream(outputFile, append);
        byte[] buffer = new byte[1024];
        while ((size = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, size);
        }
        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }

    public static void writeURL(String aURL, File outputFile) throws IOException {
        URL url = new URL(aURL);
        URLConnection connection = url.openConnection();
        BrikitFile.writeInputStream(connection.getInputStream(), outputFile);
    }
}

