/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.blueprintmaker.model.BlueprintFieldType;
import com.brikit.blueprintmaker.model.FieldValue;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FieldSwapper {
    public static final String SPACE_KEY_KEY = "SPACE KEY";
    public static final String SPACE_NAME_KEY = "SPACE NAME";
    public static final String PAGE_ID_KEY = "PAGE ID";
    public static final String PARENT_PAGE_ID_KEY = "PARENT PAGE ID";
    public static final String PAGE_TITLE_KEY = "PAGE TITLE";
    public static final String CURRENT_DATE_KEY = "CURRENT DATE";
    public static final String TEMPLATE_PAGE_ID_KEY = "templatePageId";
    public static final List<String> STANDARD_SUBSTITUTIONS = Arrays.asList("SPACE KEY", "SPACE NAME", "PAGE ID", "PARENT PAGE ID", "PAGE TITLE", "CURRENT DATE");
    protected AbstractPage blueprintPage;
    protected Map<String, FieldValue> values;
    protected Map<String, AttachmentResource> fileResources;
    Map<String, FieldValue> fileAttachmentsForCurrentPage;

    public static boolean isStandardSubstitution(String name) {
        return STANDARD_SUBSTITUTIONS.contains(name);
    }

    public void addFileResources(Map<String, AttachmentResource> fileResources) {
        if (fileResources == null) {
            return;
        }
        this.getFileResources().putAll(fileResources);
    }

    public void addValue(String key, FieldValue value) {
        this.getValues().put(key, value);
    }

    public void addValues(String valuesJSON) throws ParseException {
        if (!BrikitString.isSet(valuesJSON)) {
            return;
        }
        JSONParser parser = new JSONParser();
        this.addValues((JSONArray)parser.parse(valuesJSON));
    }

    public void addValues(JSONArray json) {
        for (Object object : json) {
            JSONObject value = (JSONObject)object;
            String name = (String)value.get((Object)"name");
            BlueprintFieldType type = null;
            if (value.containsKey((Object)"type")) {
                type = BlueprintFieldType.get((String)value.get((Object)"type"));
            }
            FieldValue fieldValue = new FieldValue(name, type, value.get((Object)"value"));
            this.getValues().put(name, fieldValue);
        }
    }

    public void addValues(Map<String, FieldValue> values) {
        this.getValues().putAll(values);
    }

    public void addValuesForDestination(AbstractPage parentPage) {
        if (parentPage == null) {
            return;
        }
        this.addValuesForDestination(Confluence.getSpaceKey(parentPage));
        BlueprintFieldType type = BlueprintFieldType.LONG;
        FieldValue fieldValue = new FieldValue(PARENT_PAGE_ID_KEY, type, (Object)parentPage.getId());
        this.addValue(PARENT_PAGE_ID_KEY, fieldValue);
    }

    public void addValuesForDestination(String destinationSpaceKey) {
        BlueprintFieldType type = BlueprintFieldType.SPACE;
        FieldValue fieldValue = new FieldValue(SPACE_KEY_KEY, type, (Object)destinationSpaceKey);
        this.addValue(SPACE_KEY_KEY, fieldValue);
        type = BlueprintFieldType.MEDIUM;
        fieldValue = new FieldValue(SPACE_NAME_KEY, type, (Object)Confluence.getSpaceName(destinationSpaceKey));
        this.addValue(SPACE_NAME_KEY, fieldValue);
    }

    public String applyData(String templateString) {
        if (!BrikitString.isSet(templateString)) {
            return templateString;
        }
        templateString = this.removeDataTemplatesDefaultMacros(templateString);
        for (Map.Entry<String, FieldValue> entry : this.getValues().entrySet()) {
            FieldValue fieldValue = entry.getValue();
            templateString = this.applyData(templateString, entry.getKey().toString(), fieldValue);
            templateString = this.updateDataTemplateFieldMacros(templateString, entry.getKey().toString(), fieldValue);
        }
        return templateString;
    }

    public String applyData(String templateString, String fieldName, FieldValue fieldValue) {
        String value = fieldValue == null ? "" : fieldValue.getStringValue();
        String fieldRegEx = this.regExForFieldName(fieldName);
        if (fieldValue.isFileType()) {
            Pattern pattern = Pattern.compile(fieldRegEx);
            Matcher matcher = pattern.matcher(templateString);
            if (matcher.find()) {
                this.getFileAttachmentsForCurrentPage().put(fieldName, fieldValue);
            }
            value = this.getFilenameFromValue(value);
        }
        value = value.replaceAll("\\$", "\\\\\\$");
        return templateString.replaceAll(fieldRegEx, BrikitString.trimToString(value));
    }

    protected String regExForFieldName(String fieldName) {
        return "\\[\\[" + fieldName + "(\\|.*?)*\\]\\]";
    }

    protected Map<String, FieldValue> getFileAttachmentsForCurrentPage() {
        if (this.fileAttachmentsForCurrentPage == null) {
            this.fileAttachmentsForCurrentPage = new HashMap<String, FieldValue>();
        }
        return this.fileAttachmentsForCurrentPage;
    }

    public void saveAttachmentsToPage(AbstractPage abstractPage) {
        for (Map.Entry<String, FieldValue> entry : this.getFileAttachmentsForCurrentPage().entrySet()) {
            String fieldName;
            AttachmentResource resource;
            FieldValue fieldValue = entry.getValue();
            if (fieldValue == null || (resource = this.getFileResource(fieldName = entry.getKey())) == null) continue;
            Attachment placeholderAttachment = Confluence.getAttachment(abstractPage, "[[" + fieldName + "]]");
            if (placeholderAttachment != null) {
                Confluence.getAttachmentManager().moveAttachment(placeholderAttachment, resource.getFilename(), (ContentEntityObject)abstractPage);
            }
            Confluence.getFileUploadManager().storeResource(resource, (ContentEntityObject)abstractPage);
        }
    }

    public String applyDataToPageBody(Space newSpace) {
        String storageFormat = this.applyData(Confluence.getBodyAsString((ContentEntityObject)this.getBlueprintPage()));
        storageFormat = storageFormat.replaceAll(Confluence.getSpaceKey(this.getBlueprintPage()), newSpace.getKey());
        storageFormat = storageFormat.replaceAll("\\[\\[\\-(.+?)\\-\\]\\]", "[[$1]]");
        return storageFormat;
    }

    public String applyDataToPageTitle() {
        return this.applyDataToPageTitle(Confluence.getTitle(this.getBlueprintPage()));
    }

    public String applyDataToPageTitle(String pageTitle) {
        String newTitle = this.applyData(pageTitle);
        BlueprintFieldType type = BlueprintFieldType.MEDIUM;
        FieldValue fieldValue = new FieldValue(PAGE_TITLE_KEY, type, (Object)newTitle);
        this.addValue(PAGE_TITLE_KEY, fieldValue);
        if (!BrikitString.isSet(newTitle)) {
            newTitle = Confluence.getText("com.brikit.blueprintmaker.null-title-placeholder", new Object[]{BrikitNumber.randomNumber(0, 999999)});
            BrikitLog.logDebug(Confluence.getText("com.brikit.blueprintmaker.null-title-error-message", new Object[]{newTitle}));
        }
        return newTitle;
    }

    public AbstractPage getBlueprintPage() {
        return this.blueprintPage;
    }

    public AbstractPage getBlueprintPageFromSavedTemplateId() {
        String pageIdAsString = this.getSavedTemplateId();
        return pageIdAsString == null ? null : Confluence.getPageOrBlogPost(pageIdAsString);
    }

    public String getFilenameFromValue(String filenameValue) {
        File fakeFile = new File(filenameValue);
        BrikitList<String> bits = new BrikitList<String>((List<String>)BrikitString.split(filenameValue, "\\\\|/"));
        String filename = bits.last();
        return filename == null ? "" : filename;
    }

    public AttachmentResource getFileResource(String fieldName) {
        FieldValue fileValue = this.getValues().get(fieldName);
        if (fileValue == null) {
            return null;
        }
        String filepath = fileValue.getStringValue();
        String filename = this.getFilenameFromValue(filepath);
        return this.getFileResources().get(filename);
    }

    public Map<String, AttachmentResource> getFileResources() {
        if (this.fileResources == null) {
            this.fileResources = new HashMap<String, AttachmentResource>();
        }
        return this.fileResources;
    }

    public String getSavedTemplateId() {
        FieldValue fieldValue = this.getValues().get(TEMPLATE_PAGE_ID_KEY);
        return fieldValue == null ? null : fieldValue.getStringValue();
    }

    public FieldValue getValue(String fieldName) {
        return this.getValues().get(fieldName);
    }

    public Map<String, FieldValue> getValues() {
        if (this.values == null) {
            this.values = new HashMap<String, FieldValue>();
            FieldValue currentDate = new FieldValue(CURRENT_DATE_KEY, BlueprintFieldType.DATE, (Object)BrikitDate.formatSimpleDate(BrikitDate.getToday()));
            this.values.put(CURRENT_DATE_KEY, currentDate);
        }
        return this.values;
    }

    public boolean needsSubstitution(String templateString, String variable) {
        return templateString.contains("[[" + variable + "]]");
    }

    protected String removeDataTemplatesDefaultMacros(String templateString) {
        if (this.getBlueprintPage() == null) {
            return templateString;
        }
        try {
            List<MacroDefinition> macros = MacroParser.extractMacrosFromStorageFormat(this.getBlueprintPage(), templateString, "data-template-defaults");
            for (MacroDefinition macro : macros) {
                templateString = MacroParser.replaceMacroInStorageFormat(this.getBlueprintPage(), templateString, macro, "");
            }
        }
        catch (Exception ex) {
            BrikitLog.logDebug("Unable parse macros from template page " + this.getBlueprintPage(), ex);
        }
        return templateString;
    }

    public void resetForNewPage() {
        this.fileAttachmentsForCurrentPage = null;
    }

    public void setBlueprintPage(AbstractPage blueprintPage) {
        this.blueprintPage = blueprintPage;
    }

    public String toProperties() {
        return this.toProperties(false);
    }

    public String toProperties(boolean includeStandardSubstitions) {
        StringBuilder builder = new StringBuilder();
        HashMap<String, FieldValue> copy = new HashMap<String, FieldValue>(this.getValues());
        for (Map.Entry entry : copy.entrySet()) {
            FieldValue fieldValue = (FieldValue)entry.getValue();
            String name = entry.getKey().toString();
            if (!includeStandardSubstitions && FieldSwapper.isStandardSubstitution(name)) continue;
            builder.append(name).append("=").append(fieldValue.getValue()).append("\n");
        }
        return builder.toString();
    }

    public String toJSON() {
        HashMap<String, FieldValue> copy = new HashMap<String, FieldValue>(this.getValues());
        if (this.getBlueprintPage() != null) {
            BlueprintFieldType type = BlueprintFieldType.LONG;
            FieldValue fieldValue = new FieldValue(TEMPLATE_PAGE_ID_KEY, type, (Object)this.getBlueprintPage().getId());
            copy.put(TEMPLATE_PAGE_ID_KEY, fieldValue);
        }
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry entry : copy.entrySet()) {
            FieldValue fieldValue = (FieldValue)entry.getValue();
            JSONObject object = new JSONObject();
            object.put((Object)"name", (Object)entry.getKey().toString());
            object.put((Object)"type", (Object)(fieldValue.getType() == null ? "" : fieldValue.getType().toString()));
            object.put((Object)"value", fieldValue.getValue());
            jsonArray.add((Object)object);
        }
        return JSONArray.toJSONString((List)jsonArray);
    }

    protected String updateDataTemplateFieldMacros(String templateString, String key, FieldValue value) {
        if (this.getBlueprintPage() == null) {
            return templateString;
        }
        try {
            List<MacroDefinition> macros = MacroParser.extractMacrosFromStorageFormat(this.getBlueprintPage(), templateString, "data-template-field", "name", key);
            for (MacroDefinition macro : macros) {
                templateString = MacroParser.replaceMacroInStorageFormat(this.getBlueprintPage(), templateString, macro, value.getStringValue());
            }
        }
        catch (Exception ex) {
            BrikitLog.logDebug("Unable parse macros from template page " + this.getBlueprintPage(), ex);
        }
        return templateString;
    }
}

