/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.brikit.blueprintmaker.actions.BlueprintMakerActionSupport;
import com.brikit.blueprintmaker.model.SpaceDefinitionSettings;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.io.File;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;

public class UploadSpaceDefinitionsAction
extends BlueprintMakerActionSupport
implements ServletRequestAware {
    protected HttpServletRequest servletRequest;

    @Override
    public String execute() throws Exception {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            File[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                File pluginFile = files[i];
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log("Uploading: " + pluginFile.getAbsolutePath());
                try {
                    SpaceDefinitionSettings.uploadSettings(pluginFile);
                    this.setResult(filename);
                    continue;
                }
                catch (Exception ex) {
                    BrikitLog.logDebug("Unable to read settings in " + filename, ex);
                    this.addActionError(BrikitString.isSet(ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename);
                    return "error";
                }
            }
        }
        return "success";
    }

    @Override
    public MultiPartRequestWrapper getMultiPartRequest() {
        return (MultiPartRequestWrapper)this.getServletRequest();
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("com.brikit.blueprintmaker.insufficient.permissions"));
        }
    }
}

