/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.blueprintmaker.events.cluster.BlueprintsUpdateClusterEvent;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.AccessPermission;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.PageBlueprintType;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitOrderedMap;
import com.brikit.core.util.BrikitString;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BlueprintDefinitions {
    public static final String BLUEPRINT_DEFINITIONS_FILENAME = "blueprint-definitions.json";
    public static final String SPACE_KEY_KEY = "spaceKey";
    public static final String SPACE_NAME_KEY = "spaceName";
    public static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    protected static final String SPACE_BLUEPRINTS_KEY = "spaceBlueprints";
    protected static final String ACCESS_LISTS_KEY = "accessLists";
    protected static final String BLUEPRINTS_FIELDS_KEY = "blueprintFields";
    protected static final String PAGE_BLUEPRINTS_KEY = "pageBlueprints";
    protected static final String NAME_KEY = "name";
    protected static final String PERMISSIONS_KEY = "permissions";
    protected static final String TYPE_KEY = "type";
    protected static final String CREATE_KEY = "create";
    protected static final String GRANT_KEY = "grant";
    protected static final String DESCRIPTION_KEY = "description";
    protected static final String ACCESS_KEY = "access";
    protected static final String SPACE_CATEGORIES_KEY = "spaceCategories";
    protected static final String BLUEPRINT_SPACE_KEY_KEY = "blueprintSpaceKey";
    protected static final String ID_KEY = "id";
    protected static final String REQUIRED_KEY = "required";
    protected static final String HELP_TEXT_KEY = "helpText";
    protected static final String VALIDATION_KEY = "validation";
    protected static final String PLACEHOLDER_KEY = "placeholder";
    protected static final String VALUES = "values";
    protected static final String MULTISELECT = "multiselect";
    protected static final String ADD_LABELS = "addLabels";
    protected static final String FILTER_GROUP = "filterGroup";
    protected static final String WORKFLOW_ID = "workflowId";
    protected static final String PAGE_TITLE_KEY = "pageTitle";
    protected static final String INCLUDE_CHILDREN_KEY = "includeChildren";
    protected static final String VISIBILITY_KEY = "visibility";
    protected static final String SPACE_METADATA_KEY = "spaceMetadata";
    protected static final String PAGE_METADATA_KEY = "pageMetadata";
    protected static final List<String> SPACE_METADATA_DEFAULT = Arrays.asList("atlassian.confluence.*", "com.brikit.*");
    protected static final List<String> PAGE_METADATA_DEFAULT = Arrays.asList("com.brikit.*");
    protected static final String CREATE_SPACE_GROUPS_KEY = "createSpaceGroups";
    protected static final String ANONYMOUS = "anonymous";
    protected static BrikitOrderedMap<String, SpaceBlueprint> spaceBlueprints;
    protected static BrikitOrderedMap<String, BlueprintField> blueprintFields;
    protected static BrikitOrderedMap<String, Access> accesses;
    protected static BrikitOrderedMap<String, PageBlueprint> pageBlueprints;
    protected static List<String> pageMetadata;
    protected static List<String> spaceMetadata;
    protected static List<String> createSpaceGroups;

    public static synchronized Map<String, Access> getAccesses() {
        if (accesses == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return accesses;
    }

    public static List<String> getCreateSpaceGroups() {
        if (createSpaceGroups == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return createSpaceGroups;
    }

    public static PageBlueprint getPageBlueprint(String blueprintName) {
        return (PageBlueprint)BlueprintDefinitions.getPageBlueprints().get(blueprintName);
    }

    public static PageBlueprint getPageBlueprint(AbstractPage blueprintPage) {
        if (blueprintPage == null) {
            return null;
        }
        for (String blueprint : BlueprintDefinitions.getPageBlueprints().getKeysInOrder()) {
            PageBlueprint pageBlueprint = (PageBlueprint)BlueprintDefinitions.getPageBlueprints().get(blueprint);
            if (pageBlueprint.getConfluencePage() == null || blueprintPage.getId() != pageBlueprint.getConfluencePage().getId()) continue;
            return pageBlueprint;
        }
        return null;
    }

    public static BrikitOrderedMap<String, PageBlueprint> getPageBlueprints() {
        if (pageBlueprints == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return pageBlueprints;
    }

    public static List<String> getPageMetadata() {
        if (pageMetadata == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return pageMetadata;
    }

    public static List<String> getSpaceMetadata() {
        if (spaceMetadata == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return spaceMetadata;
    }

    public static SpaceBlueprint getSpaceBlueprint(String blueprintName) {
        return (SpaceBlueprint)BlueprintDefinitions.getSpaceBlueprints().get(blueprintName);
    }

    public static synchronized BrikitOrderedMap<String, SpaceBlueprint> getSpaceBlueprints() {
        if (spaceBlueprints == null) {
            try {
                BlueprintDefinitions.readBlueprintsFromFile(BlueprintDefinitions.getBlueprintDefinitionsFile(), false);
            }
            catch (Exception ex) {
                if (BlueprintDefinitions.getBlueprintDefinitionsFile().exists()) {
                    BrikitLog.logError("Failed to read blueprint-definitions.json", ex);
                }
                BrikitLog.logError(ex.getMessage(), ex);
                spaceBlueprints = new BrikitOrderedMap();
                pageBlueprints = new BrikitOrderedMap();
                blueprintFields = new BrikitOrderedMap();
                accesses = new BrikitOrderedMap();
                pageMetadata = PAGE_METADATA_DEFAULT;
                spaceMetadata = SPACE_METADATA_DEFAULT;
                createSpaceGroups = new ArrayList<String>();
            }
        }
        return spaceBlueprints;
    }

    public static File getBlueprintDefinitionsFile() {
        return BrikitFile.getBrikitFile(BLUEPRINT_DEFINITIONS_FILENAME);
    }

    public static BlueprintField getBlueprintField(String name) {
        return (BlueprintField)BlueprintDefinitions.getBlueprintFields().get(name);
    }

    public static synchronized BrikitOrderedMap<String, BlueprintField> getBlueprintFields() {
        if (blueprintFields == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return blueprintFields;
    }

    protected static void readBlueprintsFromFile(File aFile, boolean validateOnly) throws Exception {
        List<String> readSpaceMetadata;
        List<String> readPageMetadata;
        JsonParser parser = new JsonParser();
        String fileContents = BrikitFile.readFile(aFile);
        JsonObject allSettingsJSON = parser.parse(fileContents).getAsJsonObject();
        List<String> list = readPageMetadata = allSettingsJSON.has(PAGE_METADATA_KEY) ? BlueprintDefinitions.unpackStringList(allSettingsJSON.get(PAGE_METADATA_KEY).getAsJsonArray()) : PAGE_METADATA_DEFAULT;
        if (readPageMetadata == null || readPageMetadata.isEmpty()) {
            readPageMetadata = PAGE_METADATA_DEFAULT;
        }
        List<String> list2 = readSpaceMetadata = allSettingsJSON.has(SPACE_METADATA_KEY) ? BlueprintDefinitions.unpackStringList(allSettingsJSON.get(SPACE_METADATA_KEY).getAsJsonArray()) : SPACE_METADATA_DEFAULT;
        if (readSpaceMetadata == null || readSpaceMetadata.isEmpty()) {
            readSpaceMetadata = SPACE_METADATA_DEFAULT;
        }
        List<String> readCreateSpaceGroups = BlueprintDefinitions.unpackStringList(allSettingsJSON.get(CREATE_SPACE_GROUPS_KEY).getAsJsonArray());
        BrikitOrderedMap<String, Access> readAccesses = BlueprintDefinitions.unpackAccesses(allSettingsJSON.get(ACCESS_LISTS_KEY).getAsJsonArray());
        BrikitOrderedMap<String, BlueprintField> readBlueprintFields = BlueprintDefinitions.unpackBlueprintFields(allSettingsJSON.get(BLUEPRINTS_FIELDS_KEY).getAsJsonArray());
        BrikitOrderedMap<String, PageBlueprint> readPageBlueprints = BlueprintDefinitions.unpackPageBlueprints(allSettingsJSON.get(PAGE_BLUEPRINTS_KEY).getAsJsonArray(), readBlueprintFields);
        BrikitOrderedMap<String, SpaceBlueprint> readSpaceBlueprints = BlueprintDefinitions.unpackSpaceBlueprints(allSettingsJSON.get(SPACE_BLUEPRINTS_KEY).getAsJsonArray(), readBlueprintFields, readAccesses);
        if (!validateOnly) {
            spaceBlueprints = readSpaceBlueprints;
            blueprintFields = readBlueprintFields;
            accesses = readAccesses;
            spaceMetadata = readSpaceMetadata;
            pageMetadata = readPageMetadata;
            pageBlueprints = readPageBlueprints;
            createSpaceGroups = readCreateSpaceGroups;
        }
    }

    public static void reset() {
        spaceBlueprints = null;
        blueprintFields = null;
        accesses = null;
        spaceMetadata = null;
        pageMetadata = null;
        pageBlueprints = null;
        createSpaceGroups = null;
    }

    protected static BrikitOrderedMap<String, Access> unpackAccesses(JsonArray accessesJSON) throws Exception {
        BrikitOrderedMap<String, Access> accesses = new BrikitOrderedMap<String, Access>();
        for (JsonElement accessObject : accessesJSON) {
            JsonObject accessJSON = accessObject.getAsJsonObject();
            String name = accessJSON.get(NAME_KEY).getAsString();
            JsonArray permissionsJSON = accessJSON.get(PERMISSIONS_KEY).getAsJsonArray();
            ArrayList<AccessPermission> permissions = new ArrayList<AccessPermission>();
            for (JsonElement permissionObject : permissionsJSON) {
                JsonObject permissionJSON = permissionObject.getAsJsonObject();
                List<String> spacePermissions = BlueprintDefinitions.unpackStringList(permissionJSON.get(GRANT_KEY).getAsJsonArray());
                String type = permissionJSON.get(TYPE_KEY).getAsString();
                String userOrGroup = ANONYMOUS.equalsIgnoreCase(type) ? "" : permissionJSON.get(NAME_KEY).getAsString();
                boolean createGroup = "group".equalsIgnoreCase(type) && permissionJSON.has(CREATE_KEY) && permissionJSON.get(CREATE_KEY).getAsBoolean();
                AccessPermission accessPermission = new AccessPermission(type, userOrGroup, spacePermissions, createGroup);
                permissions.add(accessPermission);
            }
            accesses.put(name, new Access(name, permissions));
        }
        return accesses;
    }

    protected static BrikitOrderedMap<String, PageBlueprint> unpackPageBlueprints(JsonArray pageBlueprintsJSON, BrikitOrderedMap<String, BlueprintField> readBlueprintFields) throws Exception {
        BrikitOrderedMap<String, PageBlueprint> pageBlueprints = new BrikitOrderedMap<String, PageBlueprint>();
        for (JsonElement pageBlueprint : pageBlueprintsJSON) {
            PageBlueprintType type;
            boolean includeChildren;
            JsonObject pageBlueprintJSON = pageBlueprint.getAsJsonObject();
            String pageTitle = pageBlueprintJSON.get(PAGE_TITLE_KEY).getAsString();
            String name = pageBlueprintJSON.has(NAME_KEY) ? pageBlueprintJSON.get(NAME_KEY).getAsString() : pageTitle;
            String spaceKey = pageBlueprintJSON.get(SPACE_KEY_KEY).getAsString();
            String description = pageBlueprintJSON.get(DESCRIPTION_KEY).getAsString();
            boolean bl = includeChildren = pageBlueprintJSON.has(INCLUDE_CHILDREN_KEY) ? pageBlueprintJSON.get(INCLUDE_CHILDREN_KEY).getAsBoolean() : false;
            PageBlueprintType pageBlueprintType = pageBlueprintJSON.has(TYPE_KEY) ? PageBlueprintType.get(pageBlueprintJSON.get(TYPE_KEY).getAsString()) : (type = includeChildren ? PageBlueprintType.TREE : PageBlueprintType.PAGE);
            if (type == null) {
                type = PageBlueprintType.PAGE;
            }
            ArrayList<String> spaceCategories = pageBlueprintJSON.has(VISIBILITY_KEY) ? BlueprintDefinitions.unpackStringList(pageBlueprintJSON.get(VISIBILITY_KEY).getAsJsonArray()) : new ArrayList<String>();
            Long workflowIdLong = type == PageBlueprintType.PAGE && pageBlueprintJSON.has(WORKFLOW_ID) ? Long.valueOf(pageBlueprintJSON.get(WORKFLOW_ID).getAsLong()) : null;
            Integer workflowId = workflowIdLong == null ? null : Integer.valueOf(BrikitNumber.parseInteger(Long.toString(workflowIdLong)));
            ArrayList<BlueprintField> blueprintFields = new ArrayList<BlueprintField>();
            if (pageBlueprintJSON.has(BLUEPRINTS_FIELDS_KEY)) {
                JsonArray blueprintFieldsJSON = pageBlueprintJSON.get(BLUEPRINTS_FIELDS_KEY).getAsJsonArray();
                for (JsonElement blueprintFieldJSON : blueprintFieldsJSON) {
                    String id = blueprintFieldJSON.getAsString();
                    BlueprintField blueprintField = (BlueprintField)readBlueprintFields.get(id);
                    if (blueprintField == null) continue;
                    blueprintFields.add(blueprintField);
                }
            }
            pageBlueprints.put(name, new PageBlueprint(name, spaceKey, pageTitle, description, blueprintFields, type, spaceCategories, workflowId));
        }
        return pageBlueprints;
    }

    protected static BrikitOrderedMap<String, SpaceBlueprint> unpackSpaceBlueprints(JsonArray spaceBlueprintsJSON, BrikitOrderedMap<String, BlueprintField> readBlueprintFields, BrikitOrderedMap<String, Access> allAccesses) throws Exception {
        BrikitOrderedMap<String, SpaceBlueprint> spaceBlueprints = new BrikitOrderedMap<String, SpaceBlueprint>();
        for (JsonElement spaceBlueprint : spaceBlueprintsJSON) {
            JsonObject spaceBlueprintJSON = spaceBlueprint.getAsJsonObject();
            String name = spaceBlueprintJSON.get(NAME_KEY).getAsString();
            String description = spaceBlueprintJSON.get(DESCRIPTION_KEY).getAsString();
            String categories = spaceBlueprintJSON.has(SPACE_CATEGORIES_KEY) ? spaceBlueprintJSON.get(SPACE_CATEGORIES_KEY).getAsString() : "";
            BrikitList<String> spaceCategories = BrikitString.splitCommaSeparated(categories);
            String blueprintSpaceKey = spaceBlueprintJSON.get(BLUEPRINT_SPACE_KEY_KEY).getAsString();
            String spaceKey = spaceBlueprintJSON.has(SPACE_KEY_KEY) ? spaceBlueprintJSON.get(SPACE_KEY_KEY).getAsString() : "";
            String spaceName = spaceBlueprintJSON.has(SPACE_NAME_KEY) ? spaceBlueprintJSON.get(SPACE_NAME_KEY).getAsString() : "";
            String spaceDescription = spaceBlueprintJSON.has(SPACE_DESCRIPTION_KEY) ? spaceBlueprintJSON.get(SPACE_DESCRIPTION_KEY).getAsString() : "";
            JsonArray blueprintFieldsJSON = spaceBlueprintJSON.get(BLUEPRINTS_FIELDS_KEY).getAsJsonArray();
            ArrayList<BlueprintField> blueprintFields = new ArrayList<BlueprintField>();
            for (JsonElement blueprintFieldJSON : blueprintFieldsJSON) {
                String id = blueprintFieldJSON.getAsString();
                BlueprintField blueprintField = (BlueprintField)readBlueprintFields.get(id);
                if (blueprintField == null) continue;
                blueprintFields.add(blueprintField);
            }
            JsonArray accessesJSON = spaceBlueprintJSON.get(ACCESS_KEY).getAsJsonArray();
            ArrayList<Access> accesses = new ArrayList<Access>();
            for (JsonElement accessJSON : accessesJSON) {
                String accessName = accessJSON.getAsString();
                Access access = (Access)allAccesses.get(accessName);
                if (access == null) continue;
                accesses.add(access);
            }
            spaceBlueprints.put(name, new SpaceBlueprint(name, description, spaceCategories, blueprintSpaceKey, spaceKey, spaceName, spaceDescription, blueprintFields, accesses));
        }
        return spaceBlueprints;
    }

    protected static List<String> unpackStringList(JsonArray stringListJSON) throws Exception {
        ArrayList<String> strings = new ArrayList<String>();
        for (JsonElement object : stringListJSON) {
            strings.add(object.getAsString());
        }
        return strings;
    }

    protected static BrikitOrderedMap<String, BlueprintField> unpackBlueprintFields(JsonArray blueprintFieldsJSON) throws Exception {
        BrikitOrderedMap<String, BlueprintField> blueprintFields = new BrikitOrderedMap<String, BlueprintField>();
        for (JsonElement object : blueprintFieldsJSON) {
            JsonObject blueprintFieldJSON = object.getAsJsonObject();
            String id = blueprintFieldJSON.get(ID_KEY).getAsString();
            String name = blueprintFieldJSON.get(NAME_KEY).getAsString();
            String type = blueprintFieldJSON.has(TYPE_KEY) ? blueprintFieldJSON.get(TYPE_KEY).getAsString() : "";
            String helpText = blueprintFieldJSON.has(HELP_TEXT_KEY) ? blueprintFieldJSON.get(HELP_TEXT_KEY).getAsString() : "";
            String placeholder = blueprintFieldJSON.has(PLACEHOLDER_KEY) ? blueprintFieldJSON.get(PLACEHOLDER_KEY).getAsString() : "";
            String validation = blueprintFieldJSON.has(VALIDATION_KEY) ? blueprintFieldJSON.get(VALIDATION_KEY).getAsString() : "";
            boolean required = blueprintFieldJSON.has(REQUIRED_KEY) && blueprintFieldJSON.get(REQUIRED_KEY).getAsBoolean();
            JsonArray values = blueprintFieldJSON.has(VALUES) ? blueprintFieldJSON.get(VALUES).getAsJsonArray() : new JsonArray();
            boolean multiselect = blueprintFieldJSON.has(MULTISELECT) && blueprintFieldJSON.get(MULTISELECT).getAsBoolean();
            boolean addLabels = blueprintFieldJSON.has(ADD_LABELS) && blueprintFieldJSON.get(ADD_LABELS).getAsBoolean();
            String filterGroup = blueprintFieldJSON.has(FILTER_GROUP) ? blueprintFieldJSON.get(FILTER_GROUP).getAsString() : "";
            BlueprintField blueprintField = BlueprintField.create(id, name, type, helpText, placeholder, validation, required, BlueprintDefinitions.valuesAsStrings(values), multiselect, addLabels, filterGroup);
            blueprintFields.put(id, blueprintField);
        }
        return blueprintFields;
    }

    public static synchronized void uploadSettings(File uploadedFile) throws Exception {
        BlueprintDefinitions.readBlueprintsFromFile(uploadedFile, true);
        Files.move(uploadedFile.toPath(), BlueprintDefinitions.getBlueprintDefinitionsFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        BlueprintDefinitions.reset();
        BlueprintsUpdateClusterEvent event = new BlueprintsUpdateClusterEvent(new Object());
        Confluence.getEventPublisher().publish((Object)event);
    }

    public static BrikitList<String> valuesAsStrings(JsonArray values) {
        BrikitList<String> valuesAsStrings = new BrikitList<String>(values.size());
        for (JsonElement element : values) {
            valuesAsStrings.add(element.getAsString());
        }
        return valuesAsStrings;
    }
}

