(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];
	
	BrikitCore.extend({
		
		cookies: [],
		
		// Set a cookie that expires in minutes, or session if minutes not provided
		cookie: function (cookie, value, minutes) {
			if (typeof(value) == "undefined") return $.cookie(cookie);
			
			// Keep track of Brikit cookies so they can be zapped when asked
			if (BrikitCore.cookies.indexOf(cookie) == -1) BrikitCore.cookies.push(cookie);
		
			var opts = { path: "/" };
			if (minutes) opts.expires = new Date(new Date().getTime() + minutes * 60000);
			$.cookie(cookie, value, opts);
		},
		
		// Keep track of Brikit cookies so they can be zapped when asked
		registerCookie: function (cookie) {
			if (BrikitCore.cookies.indexOf(cookie) == -1) BrikitCore.cookies.push(cookie);
		},

		zapCookie: function (cookie) {
			$.cookie(cookie, null, {path: "/"});
		},
		
		// Easter egg to zap cookies set in product
		zapCookies: function () {
            if (!BrikitCore.cookies.length) return;
            
			var zapped = [];
			$(BrikitCore.cookies).each(function () { 
				var value = BrikitCore.cookie(this);
				if (!value) return;
                zapped.push(this);
				BrikitCore.zapCookie(this);
			});
			BrikitCore.Dialog2.alert("<p>" + zapped.join("<br/>") + "</p>", {title: BrikitCore.getText("com.brikit.core.cleared.browser.cookies"), size: "medium"});
		}

	});
		
	BrikitCore.toInit( function ($) {
		// Easter egg to zap user cookies
		AJS.whenIType("qqqq").execute(BrikitCore.zapCookies);
	});

})(jQuery);
