(function ($) {
	BlueprintMaker.BlueprintDefinitions = {

	 	toggleHelpPanel: function () {
			var $helpPanel = $("#blueprint-definitions-settings-help");
			$(this).toggleAttr("aria-pressed", "true");
			$helpPanel.slideToggle();
			
	 	},
		
		upload: function (event) {

			var $uploadForm = $("#upload-settings-form");
			var $inputField = $uploadForm.find("#uploadsettings");

			// Clear out then trigger the hidden file upload form
			$inputField.val("").click();

			// When the upload filename changes, automagically upload the file and invoke the import action...
			$inputField.unbind().change(function () { 
				// ...on File selection, confirm before importing
				var fileName = $inputField.val().split('\\').pop();
				return BlueprintMaker.Dialog2.doubleConfirm("<p>" + BlueprintMaker.getText("com.brikit.blueprintmaker.import.space.templates.question", [fileName]) + "</p>", 
				  { title: BlueprintMaker.getText("com.brikit.blueprintmaker.upload.space.templates"), 
					  size: "medium", 
					  okButton: BlueprintMaker.getText("com.brikit.blueprintmaker.import.space.templates.confirm") 
				  }, function (dialog) {
					dialog.hide();
					$uploadForm.submit();
				});
			});
		
			// Convert file upload to ajax submission (using the jquery.form plugin)
			// On submission of the file upload, check server response for errors
			$uploadForm.ajaxForm(function (result) {
				if (result.indexOf("errorMessage") > -1) {
					BlueprintMaker.Dialog2.alert(result, { title: BlueprintMaker.getText("com.brikit.blueprintmaker.file.upload.error") }, BlueprintMaker.reloadBrowser);
				}
				else {
					BlueprintMaker.Dialog2.alert(
						"<p>" + BlueprintMaker.getText("com.brikit.blueprintmaker.reloading") + "</p>",
						{ title: BlueprintMaker.getText("com.brikit.blueprintmaker.success") }
					);
					BlueprintMaker.reloadBrowser(1000);
				}
			});

			return false;
		}
				
	};

})(jQuery);

BlueprintMaker.toInit(function ($) {
	$("#blueprint-definitions-settings-toolbar-help").click(BlueprintMaker.BlueprintDefinitions.toggleHelpPanel);
	$("#upload-settings").click(BlueprintMaker.BlueprintDefinitions.upload);
});
