/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.text.ParseException;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class BrikitServletFilter {
    protected static AbstractPage checkDisplayBlogPost(String path) {
        Calendar date;
        if (!path.startsWith("/display")) {
            return null;
        }
        path = path.substring(8);
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.countTokens() < 5) {
            return null;
        }
        String spaceKey = st.nextToken();
        String year = st.nextToken();
        String month = st.nextToken();
        String day = st.nextToken();
        try {
            date = BrikitDate.parseDateOnly(year + "/" + month + "/" + day);
        }
        catch (ParseException e) {
            return null;
        }
        String pageTitle = Confluence.urlDecode(st.nextToken());
        return Confluence.getBlogPost(spaceKey, pageTitle, date);
    }

    protected static AbstractPage checkDisplayPage(String path) {
        if (!path.startsWith("/display")) {
            return null;
        }
        path = path.substring(8);
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.countTokens() < 2) {
            return null;
        }
        String spaceKey = st.nextToken();
        String pageTitle = Confluence.urlDecode(st.nextToken());
        return Confluence.getPage(spaceKey, pageTitle);
    }

    protected static AbstractPage checkSpaceHomePage(String path) {
        if (!path.startsWith("/display/")) {
            return null;
        }
        path = path.substring(9);
        BrikitList<String> bits = BrikitString.split(path, "/");
        if (bits.size() > 1 && BrikitString.isSet((String)bits.get(1))) {
            return null;
        }
        return Confluence.getSpaceHomePage(bits.first());
    }

    public static AbstractPage getPage(HttpServletRequest httpRequest) {
        String path = httpRequest.getRequestURI();
        if (path.startsWith(Confluence.getContextPath())) {
            path = path.substring(Confluence.getContextPath().length());
        }
        Page abstractPage = null;
        if (path.equals("") || path.equals("/") || path.startsWith("/index.action")) {
            abstractPage = Confluence.getSiteHomePage();
        }
        if (abstractPage == null) {
            abstractPage = BrikitServletFilter.checkDisplayPage(path);
        }
        if (abstractPage == null) {
            abstractPage = BrikitServletFilter.checkDisplayBlogPost(path);
        }
        if (abstractPage == null) {
            abstractPage = BrikitServletFilter.checkSpaceHomePage(path);
        }
        if (abstractPage == null && path.startsWith("/pages/viewpage.action")) {
            abstractPage = Confluence.getPageOrBlogPost(httpRequest.getParameter("pageId"));
        }
        if (abstractPage == null && path.startsWith("/pages/viewpage.action")) {
            abstractPage = Confluence.getPage(httpRequest.getParameter("spaceKey"), httpRequest.getParameter("title"));
        }
        if (abstractPage == null && path.startsWith("/pages/viewpage.action")) {
            abstractPage = Confluence.getSpaceHomePage(httpRequest.getParameter("spaceKey"));
        }
        return abstractPage;
    }

    public boolean isSpaceHomePage(AbstractPage abstractPage, String requestURI) {
        return requestURI.endsWith("/") ? requestURI.endsWith("/display/" + abstractPage.getSpaceKey() + "/") : requestURI.endsWith("/display/" + abstractPage.getSpaceKey());
    }
}

