/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.core.TimeZone;
import com.brikit.core.confluence.Confluence;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BrikitJodaDateTime {
    protected DateTime joda;

    public BrikitJodaDateTime(Calendar calendar) {
        this(calendar.getTime());
    }

    public BrikitJodaDateTime(Calendar calendar, TimeZone timeZone) {
        this(calendar.getTime(), timeZone);
    }

    public BrikitJodaDateTime(Date date) {
        this(date, Confluence.getUserTimeZone());
    }

    public BrikitJodaDateTime(Date date, TimeZone timeZone) {
        this(date, timeZone.getWrappedTimeZone());
    }

    public BrikitJodaDateTime(Date date, java.util.TimeZone timeZone) {
        this(new DateTime((Object)date, DateTimeZone.forTimeZone((java.util.TimeZone)timeZone)));
    }

    public BrikitJodaDateTime(DateTime joda) {
        this.joda = joda;
    }

    public int getDayOfMonth() {
        return this.getJoda().getDayOfMonth();
    }

    public int getDayOfWeek() {
        return this.getJoda().getDayOfWeek();
    }

    public DateTime getJoda() {
        return this.joda;
    }

    public int getMonthOfYear() {
        return this.getJoda().getMonthOfYear();
    }

    public DateTime getNow() {
        return new DateTime(this.getZone());
    }

    public int getYear() {
        return this.getJoda().getYear();
    }

    public DateTimeZone getZone() {
        return this.getJoda().getZone();
    }

    public boolean isAfter(BrikitJodaDateTime other) {
        return this.isAfter(other.getJoda());
    }

    public boolean isAfter(DateTime other) {
        return this.getJoda().getYear() > other.getYear() || this.getJoda().getYear() == other.getYear() && this.getJoda().getMonthOfYear() > other.getMonthOfYear() || this.getJoda().getYear() == other.getYear() && this.getJoda().getMonthOfYear() == other.getMonthOfYear() && this.getJoda().getDayOfMonth() > other.getDayOfMonth();
    }

    public boolean isAfterToday() {
        return this.isAfter(this.getNow());
    }

    public boolean isBefore(BrikitJodaDateTime other) {
        return this.isBefore(other.getJoda());
    }

    public boolean isBefore(DateTime other) {
        return this.getJoda().getYear() < other.getYear() || this.getJoda().getYear() == other.getYear() && this.getJoda().getMonthOfYear() < other.getMonthOfYear() || this.getJoda().getYear() == other.getYear() && this.getJoda().getMonthOfYear() == other.getMonthOfYear() && this.getJoda().getDayOfMonth() < other.getDayOfMonth();
    }

    public boolean isBeforeToday() {
        return this.isBefore(this.getNow());
    }

    public boolean isToday() {
        DateTime now = this.getNow();
        return this.getJoda().getYear() == now.getYear() && this.getJoda().getMonthOfYear() == now.getMonthOfYear() && this.getJoda().getDayOfMonth() == now.getDayOfMonth();
    }

    public boolean isWeekend() {
        return this.getJoda().getDayOfWeek() == 6 || this.getJoda().getDayOfWeek() == 7;
    }

    public BrikitJodaDateTime minusDays(int i) {
        return new BrikitJodaDateTime(this.getJoda().minusDays(i));
    }

    public BrikitJodaDateTime plusDays(int i) {
        return new BrikitJodaDateTime(this.getJoda().plusDays(i));
    }

    public String toString(String format) {
        return this.getJoda().toString(format);
    }
}

