/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.SafeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BrikitBaseMacro
extends BaseMacro
implements Macro {
    public static final String CURRENT_USER_SYMBOL = "@user";
    public static final String NONE_SYMBOL = "@none";
    public static final String THIS_PAGE_SYMBOL = "@self";
    public static final Object PARAMETERS_KEY = "parameters";
    public static final String WIDTH_KEY = "width";
    public static final String HEIGHT_KEY = "height";
    public static final String DATE_FORMAT_KEY = "date-format";
    public static final String SUPPRESS_DATE = "none";
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String USERS_KEY = "users";
    public static final String GROUPS_KEY = "groups";
    public static final String NOT_USERS_KEY = "notusers";
    public static final String NOT_GROUPS_KEY = "notgroups";
    protected static final String DISABLE_WRAP_MACRO = "confluence.wrap.macro.disable";

    public static String buildParameterString(Map<String, String> parameters) {
        return BrikitBaseMacro.buildParameterString(parameters, false);
    }

    public static String buildParameterString(Map<String, String> parameters, boolean ignoreEmpty) {
        BrikitList<String> params = new BrikitList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (ignoreEmpty && (entry.getValue() == null || !BrikitString.isSet(entry.getValue()))) continue;
            params.add(entry.getKey() + "=" + entry.getValue());
        }
        return params.join("|");
    }

    public String errorWithHelp(String message) {
        return "<span class='error'>" + message + " Visit the <a href='http://stepstonetech.com/display/zen/help'>help page</a>.</span>";
    }

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        return "";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        return "";
    }

    public List<Link> extractLinks(String wikiMarkup) {
        return new ArrayList<Link>();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public RenderMode getBodyRenderMode() {
        return this.getBodyType().equals((Object)Macro.BodyType.NONE) ? RenderMode.NO_RENDER : RenderMode.ALL;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return true;
    }

    public String localSafeId() {
        return SafeId.localSafeId();
    }

    public String localSafeId(String root) {
        return SafeId.localSafeId(root);
    }

    public String renderTemplate(String template, BrikitMacroContext velocityContextHolder) {
        return VelocityUtils.getRenderedTemplate((String)template, (Map)velocityContextHolder.getVelocityContext());
    }
}

