/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitSize2D;
import java.awt.image.BufferedImage;

public class BrikitActionSupport
extends ConfluenceActionSupport {
    public static final String SUCCESS_KEY = "success";
    public static final String MESSAGE_KEY = "message";
    public static final String HELP_MSG = "<p>Please open a ticket at <a href='http://brikit.atlassian.net'>http://brikit.atlassian.net</a> if you need further support.</p>";
    protected String spaceKey;
    protected String pageId;
    protected String result;
    protected String url;

    public String execute() throws Exception {
        return SUCCESS_KEY;
    }

    public AbstractPage getPage() {
        return Confluence.getPageOrBlogPost(this.getPageId());
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public BrikitSize2D getPageImageSize(AbstractPage abstractPage, String attachmentName) {
        BrikitSize2D size;
        BufferedImage image = Confluence.readImageAttachment(abstractPage, attachmentName);
        BrikitSize2D brikitSize2D = size = image == null ? new BrikitSize2D(0, 0) : new BrikitSize2D(image.getHeight(), image.getWidth());
        if (image != null) {
            image.flush();
        }
        image = null;
        return size;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Space getSpace() {
        if (this.spaceKey == null && this.getPage() != null) {
            this.spaceKey = Confluence.getSpaceKey(this.getPage());
        }
        return Confluence.getSpace(this.getSpaceKey());
    }

    public String getSpaceKey() {
        if (this.spaceKey == null && this.getPage() != null) {
            this.spaceKey = Confluence.getSpaceKey(this.getPage());
        }
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String jsonError(Exception ex) {
        return this.jsonError(ex.getMessage(), ex);
    }

    public String jsonError(String message) {
        return this.jsonError(message, null);
    }

    public String jsonError(String message, Exception ex) {
        if (ex == null) {
            BrikitLog.logError(message);
        } else {
            BrikitLog.logError(message, ex);
        }
        this.setJSONError(message);
        return "error";
    }

    public String jsonSuccess(String message) {
        JSONObject json = new JSONObject();
        json.put(SUCCESS_KEY, true);
        json.put(MESSAGE_KEY, (Object)message);
        return this.setJSONSuccess(json);
    }

    public String jsonSuccess() {
        return this.jsonSuccess("");
    }

    protected BufferedImage readPageImage(AbstractPage abstractPage, String attachmentName) {
        return Confluence.readImageAttachment(abstractPage, attachmentName);
    }

    public String setJSONError(String message) {
        return this.setJSONError(message, new JSONObject());
    }

    public String setJSONError(String message, JSONObject json) {
        if (this.getActionErrors().isEmpty()) {
            this.addActionError(message);
        }
        json.put(SUCCESS_KEY, false);
        json.put(MESSAGE_KEY, (Object)message);
        this.setJSONResult(json);
        return "error";
    }

    public String setJSONMessage(String message, Object ... params) {
        JSONObject json = new JSONObject();
        json.put(SUCCESS_KEY, false);
        json.put(MESSAGE_KEY, (Object)Confluence.getText(message, params));
        this.setJSONResult(json);
        return "error";
    }

    public void setJSONResult(JSONObject jsonObject) {
        this.setResult(jsonObject.toString());
    }

    public String setJSONSuccess(JSONObject json) {
        this.setJSONResult(json);
        return SUCCESS_KEY;
    }
}

