/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.comalaworkflowsservice;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventPublisher;
import com.brikit.comalaworkflowsservice.BlogPostPublishedEvent;
import com.brikit.comalaworkflowsservice.PagePublishedEvent;
import com.comalatech.workflow.ApprovalService;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.WorkflowService;
import com.comalatech.workflow.event.StateChangeEvent;
import com.comalatech.workflow.model.State;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Comala {
    private static final Logger log = LoggerFactory.getLogger(Comala.class);
    protected ApprovalService approvalService;
    protected StateService stateService;
    protected TaskService taskService;
    protected WorkflowService workflowService;

    public Comala(ApprovalService approvalService, StateService stateService, TaskService taskService, WorkflowService workflowService) {
        this.approvalService = (ApprovalService)Preconditions.checkNotNull((Object)approvalService, (Object)"approvalService");
        this.stateService = (StateService)Preconditions.checkNotNull((Object)stateService, (Object)"stateService");
        this.taskService = (TaskService)Preconditions.checkNotNull((Object)taskService, (Object)"taskService");
        this.workflowService = (WorkflowService)Preconditions.checkNotNull((Object)workflowService, (Object)"workflowService");
    }

    public Object getApprovalService() {
        return this.approvalService;
    }

    public Object getStateService() {
        return this.stateService;
    }

    public Object getTaskService() {
        return this.workflowService;
    }

    public Object getWorkflowService() {
        return this.workflowService;
    }

    public Integer getPublishedVersion(ContentEntityObject ceo) {
        StateService service = (StateService)this.getStateService();
        State currentState = service.getCurrentState(ceo);
        List activeWorkflows = this.workflowService.getActiveWorkflows(ceo);
        if (currentState == null || activeWorkflows.size() == 0) {
            return ceo.getVersion();
        }
        State publishedState = service.getPublishedState(ceo);
        if (publishedState == null) {
            return null;
        }
        try {
            Method publishedVersionMethod = publishedState.getClass().getMethod("getVersion", new Class[0]);
            return (Integer)publishedVersionMethod.invoke((Object)publishedState, new Object[0]);
        }
        catch (Exception e) {
            log.debug("Failed Comala Workflows method invocation", (Throwable)e);
            return null;
        }
    }

    public void handleEvent(Event event, EventPublisher eventPublisher) {
        StateChangeEvent stateChangeEvent;
        if (event instanceof StateChangeEvent && (stateChangeEvent = (StateChangeEvent)event).getState().isPublished()) {
            this.handlePublishEvent(stateChangeEvent, eventPublisher);
        }
    }

    protected void handlePublishEvent(StateChangeEvent event, EventPublisher eventPublisher) {
        if (event.getContent() instanceof Page) {
            eventPublisher.publish((Object)new PagePublishedEvent("Comala Workflows Service", (Page)event.getContent()));
        } else if (event.getContent() instanceof BlogPost) {
            eventPublisher.publish((Object)new BlogPostPublishedEvent("Comala Workflows Service", (BlogPost)event.getContent()));
        }
    }
}

